/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.workflow.definition;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.inlong.manager.common.enums.TaskEvent;
import org.apache.inlong.manager.common.exceptions.WorkflowListenerException;
import org.apache.inlong.manager.workflow.definition.NextableElement;
import org.apache.inlong.manager.workflow.event.task.TaskEventListener;

public abstract class WorkflowTask
extends NextableElement {
    private boolean needAllApprove = false;
    private Map<TaskEvent, List<TaskEventListener>> listeners = Maps.newHashMap();
    private Map<String, TaskEventListener> nameToListenerMap = Maps.newHashMap();

    public WorkflowTask addListener(TaskEventListener listener) {
        if (this.nameToListenerMap.containsKey(listener.name())) {
            throw new WorkflowListenerException(String.format("duplicate listener:%s for task:%s", listener.name(), this.getName()));
        }
        this.nameToListenerMap.put(listener.name(), listener);
        this.listeners.computeIfAbsent((TaskEvent)listener.event(), a -> Lists.newArrayList()).add(listener);
        return this;
    }

    public List<TaskEventListener> listeners(TaskEvent taskEvent) {
        return this.listeners.getOrDefault(taskEvent, TaskEventListener.EMPTY_LISTENERS);
    }

    public TaskEventListener listener(String listenerName) {
        return this.nameToListenerMap.get(listenerName);
    }

    @Override
    public WorkflowTask clone() throws CloneNotSupportedException {
        WorkflowTask cloneTask = (WorkflowTask)super.clone();
        cloneTask.setListeners(new HashMap<TaskEvent, List<TaskEventListener>>(this.listeners));
        cloneTask.setNameToListenerMap(new HashMap<String, TaskEventListener>(this.nameToListenerMap));
        return cloneTask;
    }

    public boolean isNeedAllApprove() {
        return this.needAllApprove;
    }

    public Map<TaskEvent, List<TaskEventListener>> getListeners() {
        return this.listeners;
    }

    public Map<String, TaskEventListener> getNameToListenerMap() {
        return this.nameToListenerMap;
    }

    public void setNeedAllApprove(boolean needAllApprove) {
        this.needAllApprove = needAllApprove;
    }

    public void setListeners(Map<TaskEvent, List<TaskEventListener>> listeners) {
        this.listeners = listeners;
    }

    public void setNameToListenerMap(Map<String, TaskEventListener> nameToListenerMap) {
        this.nameToListenerMap = nameToListenerMap;
    }

    @Override
    public String toString() {
        return "WorkflowTask(needAllApprove=" + this.isNeedAllApprove() + ", listeners=" + this.getListeners() + ", nameToListenerMap=" + this.getNameToListenerMap() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WorkflowTask)) {
            return false;
        }
        WorkflowTask other = (WorkflowTask)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isNeedAllApprove() != other.isNeedAllApprove()) {
            return false;
        }
        Map<TaskEvent, List<TaskEventListener>> this$listeners = this.getListeners();
        Map<TaskEvent, List<TaskEventListener>> other$listeners = other.getListeners();
        if (this$listeners == null ? other$listeners != null : !((Object)this$listeners).equals(other$listeners)) {
            return false;
        }
        Map<String, TaskEventListener> this$nameToListenerMap = this.getNameToListenerMap();
        Map<String, TaskEventListener> other$nameToListenerMap = other.getNameToListenerMap();
        return !(this$nameToListenerMap == null ? other$nameToListenerMap != null : !((Object)this$nameToListenerMap).equals(other$nameToListenerMap));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof WorkflowTask;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isNeedAllApprove() ? 79 : 97);
        Map<TaskEvent, List<TaskEventListener>> $listeners = this.getListeners();
        result = result * 59 + ($listeners == null ? 43 : ((Object)$listeners).hashCode());
        Map<String, TaskEventListener> $nameToListenerMap = this.getNameToListenerMap();
        result = result * 59 + ($nameToListenerMap == null ? 43 : ((Object)$nameToListenerMap).hashCode());
        return result;
    }
}

