/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.workflow.core.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.inlong.manager.common.enums.ProcessStatus;
import org.apache.inlong.manager.common.enums.TaskStatus;
import org.apache.inlong.manager.common.exceptions.WorkflowException;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.WorkflowEventLogEntity;
import org.apache.inlong.manager.dao.entity.WorkflowProcessEntity;
import org.apache.inlong.manager.dao.entity.WorkflowTaskEntity;
import org.apache.inlong.manager.dao.mapper.WorkflowApproverEntityMapper;
import org.apache.inlong.manager.dao.mapper.WorkflowEventLogEntityMapper;
import org.apache.inlong.manager.dao.mapper.WorkflowProcessEntityMapper;
import org.apache.inlong.manager.dao.mapper.WorkflowTaskEntityMapper;
import org.apache.inlong.manager.pojo.common.CountInfo;
import org.apache.inlong.manager.pojo.workflow.ApproverPageRequest;
import org.apache.inlong.manager.pojo.workflow.ElementInfo;
import org.apache.inlong.manager.pojo.workflow.EventLogRequest;
import org.apache.inlong.manager.pojo.workflow.ProcessCountRequest;
import org.apache.inlong.manager.pojo.workflow.ProcessCountResponse;
import org.apache.inlong.manager.pojo.workflow.ProcessDetailResponse;
import org.apache.inlong.manager.pojo.workflow.ProcessInfo;
import org.apache.inlong.manager.pojo.workflow.ProcessRequest;
import org.apache.inlong.manager.pojo.workflow.TaskCountRequest;
import org.apache.inlong.manager.pojo.workflow.TaskCountResponse;
import org.apache.inlong.manager.pojo.workflow.TaskRequest;
import org.apache.inlong.manager.pojo.workflow.TaskResponse;
import org.apache.inlong.manager.pojo.workflow.form.task.TaskForm;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.core.ProcessDefinitionRepository;
import org.apache.inlong.manager.workflow.core.WorkflowQueryService;
import org.apache.inlong.manager.workflow.definition.Element;
import org.apache.inlong.manager.workflow.definition.NextableElement;
import org.apache.inlong.manager.workflow.definition.StartEvent;
import org.apache.inlong.manager.workflow.definition.UserTask;
import org.apache.inlong.manager.workflow.definition.WorkflowProcess;
import org.apache.inlong.manager.workflow.definition.WorkflowTask;
import org.apache.inlong.manager.workflow.util.WorkflowUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WorkflowQueryServiceImpl
implements WorkflowQueryService {
    private static final Logger log = LoggerFactory.getLogger(WorkflowQueryServiceImpl.class);
    @Autowired
    private ProcessDefinitionRepository definitionRepository;
    @Autowired
    private WorkflowProcessEntityMapper processEntityMapper;
    @Autowired
    private WorkflowTaskEntityMapper taskEntityMapper;
    @Autowired
    private WorkflowEventLogEntityMapper eventLogMapper;
    @Autowired
    private WorkflowApproverEntityMapper approverMapper;
    @Autowired
    private ObjectMapper objectMapper;

    @Override
    public WorkflowProcessEntity getProcessEntity(Integer processId) {
        return this.processEntityMapper.selectById(processId);
    }

    @Override
    public List<WorkflowTaskEntity> listApproveHistory(Integer processId) {
        TaskRequest request = new TaskRequest();
        request.setProcessId(processId);
        request.setStatusSet(TaskStatus.COMPLETED_STATUS);
        return this.taskEntityMapper.selectByQuery(request);
    }

    @Override
    public WorkflowTaskEntity getTaskEntity(Integer taskId) {
        return this.taskEntityMapper.selectById(taskId);
    }

    @Override
    public List<WorkflowProcessEntity> listProcessEntity(ProcessRequest query) {
        return this.processEntityMapper.selectByCondition(query);
    }

    @Override
    public List<WorkflowTaskEntity> listTaskEntity(TaskRequest taskQuery) {
        return this.taskEntityMapper.selectByQuery(taskQuery);
    }

    @Override
    public ProcessCountResponse countProcess(ProcessCountRequest request) {
        List result = this.processEntityMapper.countByQuery(request);
        HashMap countByState = new HashMap();
        result.forEach(countInfo -> countByState.put(countInfo.getKey(), countInfo.getValue()));
        return ProcessCountResponse.builder().totalApplyCount(Integer.valueOf(countByState.values().stream().mapToInt(c -> c).sum())).totalApproveCount(countByState.getOrDefault(ProcessStatus.COMPLETED.name(), 0)).totalRejectCount(countByState.getOrDefault(ProcessStatus.REJECTED.name(), 0)).totalProcessingCount(countByState.getOrDefault(ProcessStatus.PROCESSING.name(), 0)).totalCancelCount(countByState.getOrDefault(ProcessStatus.CANCELED.name(), 0)).build();
    }

    @Override
    public TaskCountResponse countTask(TaskCountRequest query) {
        List result = this.taskEntityMapper.countByQuery(query);
        TaskCountResponse response = new TaskCountResponse();
        for (CountInfo info : result) {
            String status = info.getKey();
            int total = info.getValue();
            if (TaskStatus.PENDING.name().equals(status)) {
                response.setTotalPendingCount(Integer.valueOf(total));
                continue;
            }
            if (TaskStatus.REJECTED.name().equals(status)) {
                response.setTotalRejectCount(Integer.valueOf(total));
                continue;
            }
            if (TaskStatus.APPROVED.name().equals(status)) {
                response.setTotalApproveCount(Integer.valueOf(total));
                continue;
            }
            if (!TaskStatus.TRANSFERRED.name().equals(status)) continue;
            response.setTotalTransferCount(Integer.valueOf(total));
        }
        return response;
    }

    @Override
    public ProcessDetailResponse detail(Integer processId, Integer taskId, String operator) {
        WorkflowProcessEntity processEntity = this.getProcessEntity(processId);
        if (processEntity == null) {
            return null;
        }
        WorkflowTaskEntity taskEntity = null;
        if (taskId == null) {
            if (!operator.equals(processEntity.getApplicant())) {
                throw new WorkflowException("current user is not the applicant of the process");
            }
        } else {
            ApproverPageRequest query;
            List approverList;
            boolean match;
            taskEntity = this.getTaskEntity(taskId);
            List<String> taskApprovers = Arrays.asList(taskEntity.getApprovers().split(","));
            if (!taskApprovers.contains(operator) && !(match = (approverList = this.approverMapper.selectByCondition(query = ApproverPageRequest.builder().processName(processEntity.getName()).build())).stream().anyMatch(entity -> Preconditions.inSeparatedString((String)operator, (String)entity.getApprovers(), (String)",")))) {
                throw new WorkflowException("current user is not the approver of the process");
            }
        }
        WorkflowProcess process = this.definitionRepository.get(processEntity.getName());
        TaskResponse currentTask = null;
        if (taskEntity != null) {
            currentTask = WorkflowUtils.getTaskResponse(taskEntity);
            if (process != null && TaskStatus.PENDING.equals((Object)currentTask.getStatus())) {
                WorkflowTask task = process.getTaskByName(currentTask.getName());
                currentTask.setFormData((Object)this.getEmptyTaskForm(task));
            }
            if (!processId.equals(currentTask.getProcessId())) {
                throw new WorkflowException("task [" + taskId + "] not belongs to process [" + processId + "]");
            }
        }
        ProcessDetailResponse detailResponse = this.getProcessDetail(processId, processEntity);
        detailResponse.setCurrentTask(currentTask);
        if (process == null || process.getProcessDetailHandler() == null) {
            return detailResponse;
        }
        return process.getProcessDetailHandler().handle(detailResponse);
    }

    @Override
    public WorkflowEventLogEntity getEventLog(Integer id) {
        return this.eventLogMapper.selectById(id);
    }

    @Override
    public List<WorkflowEventLogEntity> listEventLog(EventLogRequest request) {
        return this.eventLogMapper.selectByCondition(request);
    }

    private ProcessDetailResponse getProcessDetail(Integer processId, WorkflowProcessEntity processEntity) {
        List<WorkflowTaskEntity> taskList = this.listApproveHistory(processId);
        List history = taskList.stream().map(WorkflowUtils::getTaskResponse).collect(Collectors.toList());
        ProcessInfo workflowDTO = this.getBriefFromProcessEntity(processEntity);
        ProcessDetailResponse processDetail = new ProcessDetailResponse();
        processDetail.setProcessInfo(WorkflowUtils.getProcessResponse(processEntity));
        processDetail.setTaskHistory(history);
        processDetail.setWorkflow(workflowDTO);
        return processDetail;
    }

    private ProcessInfo getBriefFromProcessEntity(WorkflowProcessEntity processEntity) {
        WorkflowProcess process = this.definitionRepository.get(processEntity.getName());
        if (process == null) {
            return null;
        }
        Map<String, TaskStatus> nameStatusMap = this.getTaskNameStatusMap(processEntity);
        ElementInfo elementInfo = new ElementInfo();
        StartEvent startEvent = process.getStartEvent();
        elementInfo.setName(startEvent.getName());
        elementInfo.setDisplayName(startEvent.getDisplayName());
        WorkflowContext context = WorkflowUtils.buildContext(this.objectMapper, process, processEntity);
        this.addNext(startEvent, elementInfo, context, nameStatusMap);
        ProcessInfo processInfo = new ProcessInfo();
        processInfo.setName(process.getName());
        processInfo.setDisplayName(process.getDisplayName());
        processInfo.setType(process.getType());
        processInfo.setStartEvent(elementInfo);
        return processInfo;
    }

    private void addNext(NextableElement nextableElement, ElementInfo elementInfo, WorkflowContext context, Map<String, TaskStatus> nameToStatusMap) {
        for (Element element : nextableElement.getNextList(context)) {
            ElementInfo nextElement = new ElementInfo();
            nextElement.setName(element.getName());
            nextElement.setDisplayName(element.getDisplayName());
            if (element instanceof UserTask) {
                nextElement.setApprovers(((UserTask)element).getApproverAssign().assign(context));
                nextElement.setStatus(nameToStatusMap.get(element.getName()));
            }
            elementInfo.getNext().add(nextElement);
            if (!(element instanceof NextableElement)) continue;
            this.addNext((NextableElement)element, nextElement, context, nameToStatusMap);
        }
    }

    private Map<String, TaskStatus> getTaskNameStatusMap(WorkflowProcessEntity processEntity) {
        TaskRequest request = TaskRequest.builder().processId(processEntity.getId()).build();
        List<WorkflowTaskEntity> allTasks = this.taskEntityMapper.selectByQuery(request).stream().sorted(Comparator.comparing(WorkflowTaskEntity::getId).thenComparing(Comparator.nullsLast(Comparator.comparing(WorkflowTaskEntity::getEndTime)))).collect(Collectors.toList());
        HashMap nameStatusMap = Maps.newHashMap();
        allTasks.forEach(task -> nameStatusMap.put(task.getName(), TaskStatus.valueOf((String)task.getStatus())));
        return nameStatusMap;
    }

    private TaskForm getEmptyTaskForm(WorkflowTask task) {
        if (!(task instanceof UserTask)) {
            return null;
        }
        UserTask userTask = (UserTask)task;
        if (userTask.getFormClass() == null) {
            return null;
        }
        try {
            return userTask.getFormClass().newInstance();
        }
        catch (Exception e) {
            throw new WorkflowException("get form name failed with name " + userTask.getFormClass().getName());
        }
    }
}

