/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.corebase.utils;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.inlong.tubemq.corebase.utils.TStringUtils;

public class MixedUtils {
    private static String javaVersion = "";

    public static String getJavaVersion() {
        if (TStringUtils.isEmpty(javaVersion)) {
            return "";
        }
        int maxLen = Math.min(javaVersion.length(), 100);
        return javaVersion.substring(0, maxLen);
    }

    public static Map<String, TreeSet<String>> parseTopicParam(String topicParam) {
        String[] topicFilterStrs;
        HashMap<String, TreeSet<String>> topicAndFiltersMap = new HashMap<String, TreeSet<String>>();
        if (TStringUtils.isBlank(topicParam)) {
            return topicAndFiltersMap;
        }
        for (String topicFilterStr : topicFilterStrs = topicParam.split(",")) {
            String[] topicFilters;
            if (TStringUtils.isBlank(topicFilterStr) || TStringUtils.isBlank((topicFilters = topicFilterStr.split(":"))[0])) continue;
            TreeSet<String> filterSet = new TreeSet<String>();
            if (topicFilters.length > 1 && TStringUtils.isNotBlank(topicFilters[1])) {
                String[] filterItems;
                for (String filterItem : filterItems = topicFilters[1].split(";")) {
                    if (TStringUtils.isBlank(filterItem)) continue;
                    filterSet.add(filterItem.trim());
                }
            }
            topicAndFiltersMap.put(topicFilters[0].trim(), filterSet);
        }
        return topicAndFiltersMap;
    }

    public static byte[] buildTestData(int bodySize) {
        byte[] transmitData = StringUtils.getBytesUtf8((String)"This is a test data!");
        ByteBuffer dataBuffer = ByteBuffer.allocate(bodySize);
        while (dataBuffer.hasRemaining()) {
            int offset = dataBuffer.arrayOffset();
            dataBuffer.put(transmitData, offset, Math.min(dataBuffer.remaining(), transmitData.length));
        }
        dataBuffer.flip();
        return dataBuffer.array();
    }

    public static int mid(int data, int min, int max) {
        return Math.max(min, Math.min(max, data));
    }

    public static long mid(long data, long min, long max) {
        return Math.max(min, Math.min(max, data));
    }

    static {
        javaVersion = System.getProperty("java.version");
    }
}

