/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.corerpc.benchemark;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.inlong.tubemq.corebase.cluster.BrokerInfo;
import org.apache.inlong.tubemq.corerpc.RpcConfig;
import org.apache.inlong.tubemq.corerpc.RpcServiceFactory;
import org.apache.inlong.tubemq.corerpc.benchemark.SimpleService;
import org.apache.inlong.tubemq.corerpc.netty.NettyClientFactory;

public class RcpService4BenchmarkClient {
    private final ExecutorService executorService = Executors.newCachedThreadPool();
    private final String targetHost;
    private final int targetPort;
    private final RpcServiceFactory rpcServiceFactory;
    private final NettyClientFactory clientFactory = new NettyClientFactory();
    private SimpleService simpleService;
    private int threadNum = 10;
    private int invokeTimes = 1000000;

    public RcpService4BenchmarkClient(String targetHost, int targetPort, int threadNum, int invokeTimes) {
        this.targetHost = targetHost;
        this.targetPort = targetPort;
        this.threadNum = threadNum;
        this.invokeTimes = invokeTimes;
        RpcConfig config = new RpcConfig();
        config.put("rpc.codec", 6);
        config.put("rpc.connect.timeout", 3000);
        config.put("rpc.request.timeout", 10000);
        this.clientFactory.configure(config);
        this.rpcServiceFactory = new RpcServiceFactory(this.clientFactory);
        BrokerInfo brokerInfo = new BrokerInfo(1, targetHost, targetPort);
        this.simpleService = this.rpcServiceFactory.getService(SimpleService.class, brokerInfo, config);
    }

    public static void main(String[] args) throws Exception {
        new RcpService4BenchmarkClient("127.0.0.1", 8088, 10, 100000).start();
    }

    public void start() throws Exception {
        for (int i = 0; i < this.threadNum; ++i) {
            this.executorService.submit(new Runnable(){

                @Override
                public void run() {
                    long startTime = System.currentTimeMillis();
                    for (int j = 0; j < RcpService4BenchmarkClient.this.invokeTimes; ++j) {
                        RcpService4BenchmarkClient.this.simpleService.echo("This is a test.");
                    }
                    System.out.println(Thread.currentThread().getName() + " execute " + RcpService4BenchmarkClient.this.invokeTimes);
                    long endTime = System.currentTimeMillis() - startTime;
                    System.out.println("cost time:" + endTime + " ms");
                }
            });
        }
        this.executorService.shutdown();
        this.executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    }
}

