/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.corerpc.codec;

import com.google.protobuf.AbstractMessageLite;
import java.util.HashMap;
import java.util.Map;
import org.apache.inlong.tubemq.corebase.protobuf.generated.ClientBroker;
import org.apache.inlong.tubemq.corebase.protobuf.generated.ClientMaster;

public class PbEnDecoder {
    private static final Map<String, Integer> rpcMethodMap = new HashMap<String, Integer>();
    private static final Map<String, Integer> rpcServiceMap = new HashMap<String, Integer>();

    public static byte[] pbEncode(Object object) throws Exception {
        AbstractMessageLite rspDataMessage = (AbstractMessageLite)object;
        return rspDataMessage.toByteArray();
    }

    public static Object pbDecode(boolean isRequest, int methodId, byte[] bytes) throws Exception {
        if (isRequest) {
            switch (methodId) {
                case 1: {
                    return ClientMaster.RegisterRequestP2M.parseFrom(bytes);
                }
                case 2: {
                    return ClientMaster.HeartRequestP2M.parseFrom(bytes);
                }
                case 3: {
                    return ClientMaster.CloseRequestP2M.parseFrom(bytes);
                }
                case 4: {
                    return ClientMaster.RegisterRequestC2M.parseFrom(bytes);
                }
                case 5: {
                    return ClientMaster.HeartRequestC2M.parseFrom(bytes);
                }
                case 6: {
                    return ClientMaster.CloseRequestC2M.parseFrom(bytes);
                }
                case 7: {
                    return ClientMaster.RegisterRequestB2M.parseFrom(bytes);
                }
                case 8: {
                    return ClientMaster.HeartRequestB2M.parseFrom(bytes);
                }
                case 9: {
                    return ClientMaster.CloseRequestB2M.parseFrom(bytes);
                }
                case 13: {
                    return ClientBroker.SendMessageRequestP2B.parseFrom(bytes);
                }
                case 15: {
                    return ClientBroker.RegisterRequestC2B.parseFrom(bytes);
                }
                case 16: {
                    return ClientBroker.HeartBeatRequestC2B.parseFrom(bytes);
                }
                case 17: {
                    return ClientBroker.GetMessageRequestC2B.parseFrom(bytes);
                }
                case 18: {
                    return ClientBroker.CommitOffsetRequestC2B.parseFrom(bytes);
                }
            }
            throw new Exception(new StringBuilder(256).append("Unsupported method ID :").append(methodId).toString());
        }
        switch (methodId) {
            case 1: {
                return ClientMaster.RegisterResponseM2P.parseFrom(bytes);
            }
            case 2: {
                return ClientMaster.HeartResponseM2P.parseFrom(bytes);
            }
            case 3: {
                return ClientMaster.CloseResponseM2P.parseFrom(bytes);
            }
            case 4: {
                return ClientMaster.RegisterResponseM2C.parseFrom(bytes);
            }
            case 5: {
                return ClientMaster.HeartResponseM2C.parseFrom(bytes);
            }
            case 6: {
                return ClientMaster.CloseResponseM2C.parseFrom(bytes);
            }
            case 7: {
                return ClientMaster.RegisterResponseM2B.parseFrom(bytes);
            }
            case 8: {
                return ClientMaster.HeartResponseM2B.parseFrom(bytes);
            }
            case 9: {
                return ClientMaster.CloseResponseM2B.parseFrom(bytes);
            }
            case 13: {
                return ClientBroker.SendMessageResponseB2P.parseFrom(bytes);
            }
            case 15: {
                return ClientBroker.RegisterResponseB2C.parseFrom(bytes);
            }
            case 16: {
                return ClientBroker.HeartBeatResponseB2C.parseFrom(bytes);
            }
            case 17: {
                return ClientBroker.GetMessageResponseB2C.parseFrom(bytes);
            }
            case 18: {
                return ClientBroker.CommitOffsetResponseB2C.parseFrom(bytes);
            }
        }
        throw new Exception(new StringBuilder(256).append("Unsupported method ID :").append(methodId).toString());
    }

    public static int getMethIdByName(String methodName) throws Exception {
        Integer methodId = rpcMethodMap.get(methodName);
        if (methodId == null) {
            throw new Exception(new StringBuilder(256).append("Unsupported method name ").append(methodName).toString());
        }
        return methodId;
    }

    public static int getServiceIdByServiceName(String serviceName) throws Exception {
        Integer serviceId = rpcServiceMap.get(serviceName);
        if (serviceId == null) {
            throw new Exception(new StringBuilder(256).append("Unsupported service name ").append(serviceName).toString());
        }
        return serviceId;
    }

    public static boolean isValidServiceTypeAndMethod(int serviceId, int methodId, StringBuilder sBuilder) throws Exception {
        switch (serviceId) {
            case 1: {
                switch (methodId) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: {
                        return true;
                    }
                }
                if (sBuilder != null) {
                    sBuilder.append("Unsupported method ").append(methodId).append("in service type ").append(serviceId).append("!");
                }
                return false;
            }
            case 2: {
                switch (methodId) {
                    case 11: 
                    case 12: 
                    case 13: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: {
                        return true;
                    }
                }
                if (sBuilder != null) {
                    sBuilder.append("Unsupported method ").append(methodId).append("in service type ").append(serviceId).append("!");
                }
                return false;
            }
            case 3: {
                switch (methodId) {
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: {
                        return true;
                    }
                }
                if (sBuilder != null) {
                    sBuilder.append("Unsupported method ").append(methodId).append("in service type ").append(serviceId).append("!");
                }
                return false;
            }
        }
        if (sBuilder != null) {
            sBuilder.append("Service Type is invalid!");
        }
        return false;
    }

    static {
        rpcMethodMap.put("producerRegisterP2M", 1);
        rpcMethodMap.put("producerHeartbeatP2M", 2);
        rpcMethodMap.put("producerCloseClientP2M", 3);
        rpcMethodMap.put("consumerRegisterC2M", 4);
        rpcMethodMap.put("consumerHeartbeatC2M", 5);
        rpcMethodMap.put("consumerCloseClientC2M", 6);
        rpcMethodMap.put("brokerRegisterB2M", 7);
        rpcMethodMap.put("brokerHeartbeatB2M", 8);
        rpcMethodMap.put("brokerCloseClientB2M", 9);
        rpcMethodMap.put("consumerRegisterC2B", 15);
        rpcMethodMap.put("consumerHeartbeatC2B", 16);
        rpcMethodMap.put("getMessagesC2B", 17);
        rpcMethodMap.put("consumerCommitC2B", 18);
        rpcMethodMap.put("sendMessageP2B", 13);
        rpcServiceMap.put("org.apache.inlong.tubemq.corerpc.service.MasterService", 1);
        rpcServiceMap.put("org.apache.inlong.tubemq.corerpc.service.BrokerReadService", 2);
        rpcServiceMap.put("org.apache.inlong.tubemq.corerpc.service.BrokerWriteService", 3);
        rpcServiceMap.put("org.apache.inlong.tubemq.corerpc.service.BrokerWriteService$AsyncService", 3);
    }
}

