/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.corebase.cluster;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class ConsumerInfo
implements Comparable<ConsumerInfo>,
Serializable {
    private static final long serialVersionUID = 3095734962491009711L;
    private final String consumerId;
    private final String group;
    private final Set<String> topicSet;
    private final Map<String, TreeSet<String>> topicConditions;
    private boolean requireBound = false;
    private String sessionKey = "";
    private long startTime = -2L;
    private int sourceCount = -2;
    private boolean overTLS = false;
    private Map<String, Long> requiredPartition;

    public ConsumerInfo(String consumerId, boolean overTLS, String group, Set<String> topicSet, Map<String, TreeSet<String>> topicConditions, boolean requireBound, String sessionKey, long startTime, int sourceCount, Map<String, Long> requiredPartition) {
        this.consumerId = consumerId;
        this.overTLS = overTLS;
        this.group = group;
        this.topicSet = topicSet;
        this.topicConditions = topicConditions == null ? new HashMap<String, TreeSet<String>>() : topicConditions;
        this.requireBound = requireBound;
        this.sessionKey = sessionKey;
        this.startTime = startTime;
        this.sourceCount = sourceCount;
        this.requiredPartition = requiredPartition;
    }

    public String toString() {
        StringBuilder sBuilder = new StringBuilder(512);
        sBuilder.append(this.consumerId);
        sBuilder.append("@");
        sBuilder.append(this.group);
        sBuilder.append(":");
        int count = 0;
        for (String topicItem : this.topicSet) {
            if (count++ > 0) {
                sBuilder.append(",");
            }
            sBuilder.append(topicItem);
        }
        sBuilder.append("@overTLS=").append(this.overTLS);
        return sBuilder.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConsumerInfo)) {
            return false;
        }
        ConsumerInfo info = (ConsumerInfo)obj;
        return this.consumerId.equals(info.getConsumerId());
    }

    @Override
    public int compareTo(ConsumerInfo o) {
        if (!this.consumerId.equals(o.consumerId)) {
            return this.consumerId.compareTo(o.consumerId);
        }
        if (!this.group.equals(o.group)) {
            return this.group.compareTo(o.group);
        }
        return 0;
    }

    public boolean isRequireBound() {
        return this.requireBound;
    }

    public String getSessionKey() {
        return this.sessionKey;
    }

    public void setSessionKey(String sessionKey) {
        this.sessionKey = sessionKey;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public int getSourceCount() {
        return this.sourceCount;
    }

    public Map<String, Long> getRequiredPartition() {
        return this.requiredPartition;
    }

    public String getConsumerId() {
        return this.consumerId;
    }

    public String getGroup() {
        return this.group;
    }

    public Set<String> getTopicSet() {
        return this.topicSet;
    }

    public Map<String, TreeSet<String>> getTopicConditions() {
        return this.topicConditions;
    }

    public boolean isOverTLS() {
        return this.overTLS;
    }

    public ConsumerInfo clone() {
        return new ConsumerInfo(this.consumerId, this.overTLS, this.group, this.topicSet, this.topicConditions, this.requireBound, this.sessionKey, this.startTime, this.sourceCount, this.requiredPartition);
    }
}

