/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.corebase.cluster;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.inlong.tubemq.corebase.cluster.NodeAddrInfo;
import org.apache.inlong.tubemq.corebase.utils.TStringUtils;

public class MasterInfo {
    private final Map<String, NodeAddrInfo> addrMap4Failover = new HashMap<String, NodeAddrInfo>();
    private List<String> nodeHostPortList;
    private NodeAddrInfo firstNodeAddr = null;
    private String masterClusterStr;

    public MasterInfo(String masterAddrInfo) {
        String[] hostAndPortArray;
        if (TStringUtils.isBlank(masterAddrInfo)) {
            throw new IllegalArgumentException("Illegal parameter: masterAddrInfo is Blank!");
        }
        if (!masterAddrInfo.contains(":")) {
            throw new IllegalArgumentException("Illegal parameter: masterAddrInfo's value must like \"ip1:port,ip2:port\"!");
        }
        for (String addr : hostAndPortArray = masterAddrInfo.split(",")) {
            if (TStringUtils.isBlank(addr)) {
                throw new IllegalArgumentException("Illegal parameter: masterAddrInfo's value must like \"ip1:port,ip2:port\" and ip:port not Blank!");
            }
            String[] hostPortItem = addr.split(":");
            if (hostPortItem.length != 2) {
                throw new IllegalArgumentException("Illegal parameter: masterAddrInfo's value must like \"ip1:port,ip2:port\"!");
            }
            String hostName = hostPortItem[0].trim();
            if (TStringUtils.isBlank(hostName)) {
                throw new IllegalArgumentException("Illegal parameter: masterAddrInfo's value must like \"ip1:port,ip2:port\" and ip's value not Blank!");
            }
            if (TStringUtils.isBlank(hostPortItem[1])) {
                throw new IllegalArgumentException("Illegal parameter: masterAddrInfo's value must like \"ip1:port,ip2:port\" and port's value not Blank!");
            }
            int port = Integer.parseInt(hostPortItem[1].trim());
            NodeAddrInfo tmpNodeAddrInfo = new NodeAddrInfo(hostName, port);
            if (this.addrMap4Failover.get(tmpNodeAddrInfo.getHostPortStr()) == null) {
                this.addrMap4Failover.put(tmpNodeAddrInfo.getHostPortStr(), tmpNodeAddrInfo);
            }
            if (this.firstNodeAddr != null) continue;
            this.firstNodeAddr = tmpNodeAddrInfo;
        }
        this.nodeHostPortList = new ArrayList<String>(this.addrMap4Failover.size());
        this.nodeHostPortList.addAll(this.addrMap4Failover.keySet());
        int count = 0;
        Collections.sort(this.nodeHostPortList);
        StringBuilder builder = new StringBuilder(256);
        for (String nodeStr : this.nodeHostPortList) {
            if (count++ > 0) {
                builder.append(",");
            }
            builder.append(nodeStr);
        }
        this.masterClusterStr = builder.toString();
    }

    private MasterInfo(Map<String, NodeAddrInfo> addressMap4Failover, NodeAddrInfo firstNodeAddr, String masterClusterStr) {
        for (Map.Entry<String, NodeAddrInfo> entry : addressMap4Failover.entrySet()) {
            if (TStringUtils.isBlank(entry.getKey()) || entry.getValue() == null) continue;
            this.addrMap4Failover.put(entry.getKey(), entry.getValue());
        }
        this.nodeHostPortList = new ArrayList<String>(this.addrMap4Failover.size());
        this.nodeHostPortList.addAll(this.addrMap4Failover.keySet());
        this.firstNodeAddr = firstNodeAddr;
        this.masterClusterStr = masterClusterStr;
    }

    public Map<String, NodeAddrInfo> getAddrMap4Failover() {
        return this.addrMap4Failover;
    }

    public String getMasterClusterStr() {
        return this.masterClusterStr;
    }

    public List<String> getNodeHostPortList() {
        return this.nodeHostPortList;
    }

    public String toString() {
        return this.firstNodeAddr.getHostPortStr();
    }

    public int hashCode() {
        return this.masterClusterStr.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof MasterInfo)) {
            return false;
        }
        MasterInfo other = (MasterInfo)o;
        if (this.addrMap4Failover.size() != other.addrMap4Failover.size()) {
            return false;
        }
        for (String address : this.addrMap4Failover.keySet()) {
            if (other.addrMap4Failover.get(address) != null) continue;
            return false;
        }
        return true;
    }

    public MasterInfo clone() {
        return new MasterInfo(this.addrMap4Failover, this.firstNodeAddr, this.masterClusterStr);
    }
}

