/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.corerpc.netty;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.inlong.tubemq.corebase.utils.AddressUtils;
import org.apache.inlong.tubemq.corerpc.RpcDataPack;
import org.apache.inlong.tubemq.corerpc.exception.UnknownProtocolException;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.frame.FrameDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyProtocolDecoder
extends FrameDecoder {
    private static final Logger logger = LoggerFactory.getLogger(NettyProtocolDecoder.class);
    private static final ConcurrentHashMap<String, AtomicLong> errProtolAddrMap = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, AtomicLong> errSizeAddrMap = new ConcurrentHashMap();
    private static AtomicLong lastProtolTime = new AtomicLong(0L);
    private static AtomicLong lastSizeTime = new AtomicLong(0L);
    private boolean packHeaderRead = false;
    private int listSize;
    private RpcDataPack dataPack;

    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) throws Exception {
        if (!this.packHeaderRead) {
            if (buffer.readableBytes() < 12) {
                return null;
            }
            int frameToken = buffer.readInt();
            this.filterIllegalPkgToken(frameToken, -8391426, channel);
            int serialNo = buffer.readInt();
            int tmpListSize = buffer.readInt();
            this.filterIllegalPackageSize(true, tmpListSize, 3584, channel);
            this.listSize = tmpListSize;
            this.dataPack = new RpcDataPack(serialNo, new ArrayList<ByteBuffer>(this.listSize));
            this.packHeaderRead = true;
        }
        if (buffer.readableBytes() < 4) {
            return null;
        }
        buffer.markReaderIndex();
        int length = buffer.readInt();
        this.filterIllegalPackageSize(false, length, 8192, channel);
        if (buffer.readableBytes() < length) {
            buffer.resetReaderIndex();
            return null;
        }
        ByteBuffer bb = ByteBuffer.allocate(length);
        buffer.readBytes(bb);
        bb.flip();
        this.dataPack.getDataLst().add(bb);
        if (this.dataPack.getDataLst().size() == this.listSize) {
            this.packHeaderRead = false;
            return this.dataPack;
        }
        return null;
    }

    private void filterIllegalPkgToken(int inParamValue, int allowTokenVal, Channel channel) throws UnknownProtocolException {
        if (inParamValue != allowTokenVal) {
            String rmtaddrIp = AddressUtils.getRemoteAddressIP(channel);
            if (rmtaddrIp != null) {
                AtomicLong tmpCount;
                AtomicLong count = errProtolAddrMap.get(rmtaddrIp);
                if (count == null && (count = errProtolAddrMap.putIfAbsent(rmtaddrIp, tmpCount = new AtomicLong(0L))) == null) {
                    count = tmpCount;
                }
                count.incrementAndGet();
                long befTime = lastProtolTime.get();
                long curTime = System.currentTimeMillis();
                if (curTime - befTime > 180000L && lastProtolTime.compareAndSet(befTime, System.currentTimeMillis())) {
                    logger.warn("[Abnormal Visit] OSS Tube visit list is :" + errProtolAddrMap.toString());
                    errProtolAddrMap.clear();
                }
            }
            throw new UnknownProtocolException(new StringBuilder(256).append("Unknown protocol exception for message frame, channel.address = ").append(channel.getRemoteAddress().toString()).toString());
        }
    }

    private void filterIllegalPackageSize(boolean isFrameSize, int inParamValue, int allowSize, Channel channel) throws UnknownProtocolException {
        if (inParamValue < 0 || inParamValue > allowSize) {
            String rmtaddrIp = AddressUtils.getRemoteAddressIP(channel);
            if (rmtaddrIp != null) {
                AtomicLong tmpCount;
                AtomicLong count = errSizeAddrMap.get(rmtaddrIp);
                if (count == null && (count = errSizeAddrMap.putIfAbsent(rmtaddrIp, tmpCount = new AtomicLong(0L))) == null) {
                    count = tmpCount;
                }
                count.incrementAndGet();
                long befTime = lastSizeTime.get();
                long curTime = System.currentTimeMillis();
                if (curTime - befTime > 180000L && lastSizeTime.compareAndSet(befTime, System.currentTimeMillis())) {
                    logger.warn("[Abnormal Visit] Abnormal BodySize visit list is :" + errSizeAddrMap.toString());
                    errSizeAddrMap.clear();
                }
            }
            StringBuilder sBuilder = new StringBuilder(256).append("Unknown protocol exception for message listSize! channel.address = ").append(channel.getRemoteAddress().toString());
            if (isFrameSize) {
                sBuilder.append(", Max list size=").append(allowSize).append(", request's list size=").append(inParamValue);
            } else {
                sBuilder.append(", Max buffer size=").append(allowSize).append(", request's buffer size=").append(inParamValue);
            }
            throw new UnknownProtocolException(sBuilder.toString());
        }
    }
}

