/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.corebase.balance;

public enum EventType {
    CONNECT(1, "Connect to some broker after Disconnecting from some other broker."),
    DISCONNECT(2, "Disconnect from some broker."),
    REPORT(3, "Report current status."),
    REFRESH(4, "Update whole producer published topic info"),
    STOPREBALANCE(5, "Stop rebalance thread"),
    ONLY_CONNECT(10, "Only connect to some broker"),
    ONLY_DISCONNECT(20, "Disconnect from some broker,then finish."),
    UNKNOWN(-1, "Unknown operation type");

    private int value;
    private String description;

    private EventType(int value, String description) {
        this.value = value;
        this.description = description;
    }

    public int getValue() {
        return this.value;
    }

    public String getDesc() {
        return this.description;
    }

    public static EventType valueOf(int value) {
        for (EventType type : EventType.values()) {
            if (type.getValue() != value) continue;
            return type;
        }
        return UNKNOWN;
    }
}

