/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.corebase.metric;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.inlong.tubemq.corebase.metric.MetricType;
import org.apache.inlong.tubemq.corebase.metric.MetricValueType;
import org.apache.inlong.tubemq.corebase.utils.Tuple2;

public abstract class AbsMetricItem {
    protected final MetricType metricType;
    protected final MetricValueType valueType;
    protected final String name;
    protected final AtomicLong value = new AtomicLong(0L);

    public AbsMetricItem(MetricType metricType, MetricValueType valueType, String name, long initialValue) {
        this.metricType = metricType;
        this.valueType = valueType;
        this.name = name;
        this.value.set(initialValue);
    }

    public String getName() {
        return this.name;
    }

    public long getValue() {
        return this.value.get();
    }

    public boolean isCounterMetric() {
        return this.metricType == MetricType.COUNTER;
    }

    public MetricType getMetricType() {
        return this.metricType;
    }

    public MetricValueType getMetricValueType() {
        return this.valueType;
    }

    public Tuple2<String, Long> getNameValue() {
        return new Tuple2<String, Long>(this.name, this.value.get());
    }

    public long incrementAndGet() {
        return this.value.incrementAndGet();
    }

    public boolean compareAndSet(long expect, long update) {
        return this.value.compareAndSet(expect, update);
    }

    public long decrementAndGet() {
        return this.value.decrementAndGet();
    }

    public abstract long getAndSet();

    public abstract boolean update(long var1);
}

