/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.corebase.metric;

public enum MetricValueType {
    NORMAL(0, "Normal", "Current value"),
    MIN(1, "Min", "Historical minimum value"),
    MAX(2, "Max", "Historical maximum value");

    private final int id;
    private final String name;
    private final String desc;

    private MetricValueType(int id, String name, String desc) {
        this.id = id;
        this.name = name;
        this.desc = desc;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDesc() {
        return this.desc;
    }

    public static MetricValueType valueOf(int value) {
        for (MetricValueType valueType : MetricValueType.values()) {
            if (valueType.getId() != value) continue;
            return valueType;
        }
        return NORMAL;
    }
}

