/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.corebase.utils;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import org.apache.inlong.tubemq.corebase.exception.AddressException;
import org.apache.inlong.tubemq.corebase.utils.TStringUtils;
import org.apache.inlong.tubemq.corebase.utils.Tuple2;
import org.jboss.netty.channel.Channel;

public class AddressUtils {
    private static String localIPAddress = null;

    public static synchronized String getLocalAddress() throws Exception {
        if (TStringUtils.isBlank(localIPAddress)) {
            throw new Exception("Local IP is blank, Please initial Client's Configure first!");
        }
        return localIPAddress;
    }

    @Deprecated
    public static boolean validLocalIp(String currLocalHost) {
        if (TStringUtils.isNotEmpty(localIPAddress) && localIPAddress.equals(currLocalHost)) {
            return true;
        }
        Enumeration<NetworkInterface> allInterface = AddressUtils.listNetworkInterface();
        return AddressUtils.checkValidIp(allInterface, currLocalHost);
    }

    private static boolean checkValidIp(Enumeration<NetworkInterface> allInterface, String currLocalHost) {
        String fstV4IP = null;
        while (allInterface.hasMoreElements()) {
            try {
                Tuple2<Boolean, String> result = AddressUtils.getValidIPV4Address(allInterface.nextElement(), currLocalHost);
                if (result.getF0().booleanValue()) {
                    localIPAddress = currLocalHost;
                    return true;
                }
                if (!TStringUtils.isEmpty(fstV4IP)) continue;
                fstV4IP = result.getF1();
            }
            catch (Throwable throwable) {}
        }
        if (fstV4IP != null) {
            localIPAddress = fstV4IP;
            return true;
        }
        throw new AddressException(new StringBuilder(256).append("Illegal parameter: not found the ip(").append(currLocalHost).append(") or ip v4 address in local networkInterfaces!").toString());
    }

    public static int ipToInt(String ipAddr) {
        try {
            return AddressUtils.bytesToInt(AddressUtils.toBytes(ipAddr));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(ipAddr + " is invalid IP");
        }
    }

    public static String intToIp(int ipInt) {
        return new StringBuilder(128).append(ipInt >> 24 & 0xFF).append('.').append(ipInt >> 16 & 0xFF).append('.').append(ipInt >> 8 & 0xFF).append('.').append(ipInt & 0xFF).toString();
    }

    public static byte[] toBytes(String ipAddr) {
        byte[] ret = new byte[4];
        try {
            String[] ipArr = ipAddr.split("\\.");
            ret[0] = (byte)(Integer.parseInt(ipArr[0]) & 0xFF);
            ret[1] = (byte)(Integer.parseInt(ipArr[1]) & 0xFF);
            ret[2] = (byte)(Integer.parseInt(ipArr[2]) & 0xFF);
            ret[3] = (byte)(Integer.parseInt(ipArr[3]) & 0xFF);
            return ret;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(ipAddr + " is invalid IP");
        }
    }

    public static int bytesToInt(byte[] bytes) {
        int addr = bytes[3] & 0xFF;
        addr |= bytes[2] << 8 & 0xFF00;
        addr |= bytes[1] << 16 & 0xFF0000;
        return addr |= bytes[0] << 24 & 0xFF000000;
    }

    public static String getRemoteAddressIP(Channel channel) {
        String strRemoteIP = null;
        if (channel == null) {
            return strRemoteIP;
        }
        SocketAddress remoteSocketAddress = channel.getRemoteAddress();
        if (null != remoteSocketAddress) {
            strRemoteIP = remoteSocketAddress.toString();
            try {
                strRemoteIP = strRemoteIP.substring(1, strRemoteIP.indexOf(58));
            }
            catch (Exception ee) {
                return strRemoteIP;
            }
        }
        return strRemoteIP;
    }

    public static Enumeration<NetworkInterface> listNetworkInterface() {
        try {
            return NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            throw new AddressException(e);
        }
    }

    public static String getIPV4LocalAddress() {
        if (localIPAddress != null) {
            return localIPAddress;
        }
        String tmpAdress = null;
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            if (enumeration == null) {
                throw new AddressException("Get NetworkInterfaces is null");
            }
            while (enumeration.hasMoreElements()) {
                try {
                    Tuple2<Boolean, String> result = AddressUtils.getValidIPV4Address(enumeration.nextElement(), null);
                    if (!result.getF0().booleanValue()) continue;
                    tmpAdress = result.getF1();
                    break;
                }
                catch (Throwable throwable) {
                }
            }
            if (tmpAdress == null) {
                tmpAdress = InetAddress.getLocalHost().getHostAddress();
            }
            if (tmpAdress != null) {
                localIPAddress = tmpAdress;
                return tmpAdress;
            }
        }
        catch (SocketException | UnknownHostException e) {
            throw new AddressException("Call getIPV4LocalAddress throw exception", e);
        }
        throw new AddressException(new StringBuilder(256).append("Illegal parameter: not found the default ip").append(" in local networkInterfaces!").toString());
    }

    public static String getIPV4LocalAddress(String defEthName) {
        boolean foundNetInter = false;
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            if (enumeration == null) {
                throw new AddressException("Get NetworkInterfaces is null");
            }
            while (enumeration.hasMoreElements()) {
                NetworkInterface oneInterface = enumeration.nextElement();
                if (oneInterface == null || oneInterface.isLoopback() || !oneInterface.isUp() || !defEthName.equalsIgnoreCase(oneInterface.getName())) continue;
                foundNetInter = true;
                try {
                    Tuple2<Boolean, String> result = AddressUtils.getValidIPV4Address(oneInterface, null);
                    if (!result.getF0().booleanValue()) continue;
                    localIPAddress = result.getF1();
                    return localIPAddress;
                }
                catch (Throwable throwable) {
                }
            }
        }
        catch (Throwable e) {
            throw new AddressException("Call getDefNetworkAddress throw exception", e);
        }
        if (foundNetInter) {
            throw new AddressException(new StringBuilder(256).append("Illegal parameter: not found valid ip").append(" in networkInterfaces ").append(defEthName).toString());
        }
        throw new AddressException(new StringBuilder(256).append("Illegal parameter: ").append(defEthName).append(" does not exist or is not in a valid state!").toString());
    }

    public static Tuple2<Boolean, String> getValidIPV4Address(NetworkInterface networkInterface, String checkIp) {
        try {
            if (networkInterface == null || !networkInterface.isUp() || networkInterface.isLoopback() || "docker0".equals(networkInterface.getName())) {
                return new Tuple2<Boolean, Object>(false, null);
            }
            String fstV4IP = null;
            Enumeration<InetAddress> addrs = networkInterface.getInetAddresses();
            while (addrs.hasMoreElements()) {
                String localIP;
                InetAddress address = addrs.nextElement();
                if (address == null || address.isLoopbackAddress() || address instanceof Inet6Address || TStringUtils.isEmpty(localIP = address.getHostAddress()) || localIP.startsWith("127.0")) continue;
                if (!TStringUtils.isEmpty(checkIp)) {
                    if (TStringUtils.isEmpty(fstV4IP)) {
                        fstV4IP = localIP;
                    }
                    if (!localIP.equals(checkIp)) continue;
                    return new Tuple2<Boolean, String>(true, localIP);
                }
                return new Tuple2<Boolean, String>(true, localIP);
            }
            return new Tuple2<Boolean, Object>(false, fstV4IP);
        }
        catch (Throwable e) {
            throw new AddressException(new StringBuilder(256).append("Illegal parameter: ").append("unable to obtain valid IP from network card ").append(networkInterface).toString(), e);
        }
    }
}

