/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.corerpc.netty;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLEngine;
import org.apache.inlong.tubemq.corebase.cluster.NodeAddrInfo;
import org.apache.inlong.tubemq.corerpc.RpcConfig;
import org.apache.inlong.tubemq.corerpc.RpcConstants;
import org.apache.inlong.tubemq.corerpc.client.Client;
import org.apache.inlong.tubemq.corerpc.client.ClientFactory;
import org.apache.inlong.tubemq.corerpc.exception.LocalConnException;
import org.apache.inlong.tubemq.corerpc.netty.NettyClient;
import org.apache.inlong.tubemq.corerpc.netty.NettyProtocolDecoder;
import org.apache.inlong.tubemq.corerpc.netty.NettyProtocolEncoder;
import org.apache.inlong.tubemq.corerpc.netty.ReadTimeoutHandler;
import org.apache.inlong.tubemq.corerpc.utils.TSSLEngineUtil;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioWorkerPool;
import org.jboss.netty.channel.socket.nio.WorkerPool;
import org.jboss.netty.handler.execution.ExecutionHandler;
import org.jboss.netty.handler.execution.MemoryAwareThreadPoolExecutor;
import org.jboss.netty.handler.ssl.SslHandler;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.ThreadNameDeterminer;
import org.jboss.netty.util.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyClientFactory
implements ClientFactory {
    private static final Logger logger = LoggerFactory.getLogger(NettyClientFactory.class);
    protected final ConcurrentHashMap<String, Client> clients = new ConcurrentHashMap();
    protected AtomicBoolean shutdown = new AtomicBoolean(true);
    private Timer timer = new HashedWheelTimer();
    private volatile AtomicBoolean init = new AtomicBoolean(true);
    private ChannelFactory channelFactory;
    private MemoryAwareThreadPoolExecutor eventExecutor;
    private ExecutorService bossExecutorService;
    private ExecutorService workerExecutorService;
    private AtomicInteger workerIdCounter = new AtomicInteger(0);
    private RpcConfig factoryConf;
    private boolean enableTLS = false;
    private boolean needTwoWayAuthentic = false;
    private String keyStorePath;
    private String keyStorePassword;
    private String trustStorePath;
    private String trustStorePassword;

    public void configure(final RpcConfig conf) throws IllegalArgumentException {
        if (this.init.compareAndSet(false, true)) {
            this.timer = new HashedWheelTimer();
        }
        if (this.shutdown.compareAndSet(true, false)) {
            this.factoryConf = conf;
            this.enableTLS = conf.getBoolean("tcp.tls", false);
            this.needTwoWayAuthentic = conf.getBoolean("tls.twoway.authentic", false);
            if (this.enableTLS) {
                this.trustStorePath = conf.getString("tls.truststore.path");
                this.trustStorePassword = conf.getString("tls.truststore.password");
                if (this.needTwoWayAuthentic) {
                    this.keyStorePath = conf.getString("tls.keystore.path");
                    this.keyStorePassword = conf.getString("tls.keystore.password");
                } else {
                    this.keyStorePath = null;
                    this.keyStorePassword = null;
                }
            } else {
                this.keyStorePath = null;
                this.keyStorePassword = null;
                this.trustStorePath = null;
                this.trustStorePassword = null;
            }
            int bossCount = conf.getInt("rpc.netty.boss.count", 1);
            int workerCount = conf.getInt("rpc.netty.worker.count", RpcConstants.CFG_DEFAULT_CLIENT_WORKER_COUNT);
            int callbackCount = conf.getInt("rpc.netty.callback.count", 3);
            this.bossExecutorService = Executors.newCachedThreadPool();
            this.workerExecutorService = Executors.newCachedThreadPool();
            this.channelFactory = new NioClientSocketChannelFactory((Executor)this.bossExecutorService, bossCount, (WorkerPool)new NioWorkerPool((Executor)this.workerExecutorService, workerCount, new ThreadNameDeterminer(){

                public String determineThreadName(String currentThreadName, String proposedThreadName) throws Exception {
                    return new StringBuilder(256).append(conf.getString("rpc.netty.worker.thread.name", "tube_rpc_netty_worker-")).append(NettyClientFactory.this.workerIdCounter.incrementAndGet()).toString();
                }
            }));
            this.eventExecutor = new MemoryAwareThreadPoolExecutor(callbackCount, (long)conf.getInt("rpc.netty.worker.mem.size", 0xA00000), (long)conf.getInt("rpc.netty.worker.mem.size", 0xA00000));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Client getClient(NodeAddrInfo addressInfo, RpcConfig conf) throws Exception {
        Client client = this.clients.get(addressInfo.getHostPortStr());
        if (client != null && client.isReady()) {
            return client;
        }
        NettyClientFactory nettyClientFactory = this;
        synchronized (nettyClientFactory) {
            client = this.clients.get(addressInfo.getHostPortStr());
            if (client != null && client.isReady()) {
                return client;
            }
            if (client != null) {
                client = this.clients.remove(addressInfo.getHostPortStr());
                if (client != null) {
                    client.close();
                }
                client = null;
            }
            int connectTimeout = conf.getInt("rpc.connect.timeout", 3000);
            try {
                client = this.createClient(addressInfo, connectTimeout, conf);
                Client existClient = this.clients.putIfAbsent(addressInfo.getHostPortStr(), client);
                if (existClient != null) {
                    client.close(false);
                    client = existClient;
                }
            }
            catch (LocalConnException e) {
                if (client != null) {
                    client.close(false);
                }
                throw e;
            }
            catch (Exception e) {
                if (client != null) {
                    client.close(false);
                }
                throw e;
            }
            catch (Throwable ee) {
                if (client != null) {
                    client.close(false);
                }
                throw new Exception(ee);
            }
        }
        return client;
    }

    @Override
    public Client removeClient(NodeAddrInfo addressInfo) {
        return this.clients.remove(addressInfo.getHostPortStr());
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        if (this.init.compareAndSet(true, false)) {
            this.timer.stop();
        }
        if (this.shutdown.compareAndSet(false, true)) {
            try {
                if (!this.clients.isEmpty()) {
                    for (String key : this.clients.keySet()) {
                        Client client;
                        if (key == null || (client = this.clients.remove(key)) == null) continue;
                        client.close();
                    }
                }
                if (this.bossExecutorService != null) {
                    this.bossExecutorService.shutdown();
                }
                if (this.workerExecutorService != null) {
                    this.workerExecutorService.shutdown();
                }
                if (this.eventExecutor != null) {
                    this.eventExecutor.shutdown();
                }
            }
            finally {
                this.channelFactory.releaseExternalResources();
                this.channelFactory.shutdown();
            }
        }
    }

    private Client createClient(final NodeAddrInfo addressInfo, int connectTimeout, final RpcConfig conf) throws Exception {
        final NettyClient client = new NettyClient(this, connectTimeout);
        ClientBootstrap clientBootstrap = new ClientBootstrap();
        clientBootstrap.setOption("tcpNoDelay", (Object)true);
        clientBootstrap.setOption("reuseAddress", (Object)true);
        clientBootstrap.setOption("connectTimeoutMillis", (Object)connectTimeout);
        clientBootstrap.setFactory(this.channelFactory);
        long nettyWriteHighMark = conf.getLong("rpc.netty.write.highmark", -1L);
        long nettyWriteLowMark = conf.getLong("rpc.netty.write.lowmark", -1L);
        if (nettyWriteHighMark > 0L) {
            clientBootstrap.setOption("writeBufferHighWaterMark", (Object)nettyWriteHighMark);
        }
        if (nettyWriteLowMark > 0L) {
            clientBootstrap.setOption("writeBufferLowWaterMark", (Object)nettyWriteLowMark);
        }
        clientBootstrap.setPipelineFactory(new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                ChannelPipeline pipeline = Channels.pipeline();
                if (NettyClientFactory.this.enableTLS) {
                    try {
                        SSLEngine sslEngine = TSSLEngineUtil.createSSLEngine(NettyClientFactory.this.keyStorePath, NettyClientFactory.this.trustStorePath, NettyClientFactory.this.keyStorePassword, NettyClientFactory.this.trustStorePassword, true, NettyClientFactory.this.needTwoWayAuthentic);
                        pipeline.addLast("ssl", (ChannelHandler)new SslHandler(sslEngine));
                    }
                    catch (Throwable t) {
                        logger.error(new StringBuilder(256).append("Create SSLEngine to connection ").append(addressInfo.getHostPortStr()).append(" failure!").toString(), t);
                        throw new Exception(t);
                    }
                }
                pipeline.addLast("protocolEncoder", (ChannelHandler)new NettyProtocolEncoder());
                pipeline.addLast("protocolDecoder", (ChannelHandler)new NettyProtocolDecoder());
                pipeline.addLast("readTimeoutHandler", (ChannelHandler)new ReadTimeoutHandler(NettyClientFactory.this.timer, conf.getLong("rpc.connect.read.idle.duration", 300000L), TimeUnit.MILLISECONDS));
                pipeline.addLast("execution", (ChannelHandler)new ExecutionHandler((Executor)NettyClientFactory.this.eventExecutor));
                pipeline.addLast("clientHandler", (ChannelHandler)new NettyClient.NettyClientHandler(client));
                return pipeline;
            }
        });
        ChannelFuture future = clientBootstrap.connect((SocketAddress)new InetSocketAddress(addressInfo.getHost(), addressInfo.getPort()));
        future.awaitUninterruptibly((long)connectTimeout);
        if (!future.isDone()) {
            future.cancel();
            throw new LocalConnException(new StringBuilder(256).append("Create connection to ").append(addressInfo.getHostPortStr()).append(" timeout!").toString());
        }
        if (future.isCancelled()) {
            throw new LocalConnException(new StringBuilder(256).append("Create connection to ").append(addressInfo.getHostPortStr()).append(" cancelled by user!").toString());
        }
        if (!future.isSuccess()) {
            throw new LocalConnException(new StringBuilder(256).append("Create connection to ").append(addressInfo.getHostPortStr()).append(" error").toString(), future.getCause());
        }
        client.setChannel(future.getChannel(), addressInfo);
        return client;
    }
}

