/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.corerpc.netty;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.inlong.tubemq.corerpc.RpcDataPack;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.oneone.OneToOneEncoder;

public class NettyProtocolEncoder
extends OneToOneEncoder {
    protected Object encode(ChannelHandlerContext ctx, Channel channel, Object msg) throws Exception {
        RpcDataPack dataPack = (RpcDataPack)msg;
        List<ByteBuffer> origs = dataPack.getDataLst();
        ArrayList<ByteBuffer> bbs = new ArrayList<ByteBuffer>(origs.size() * 2 + 1);
        bbs.add(this.getPackHeader(dataPack));
        for (ByteBuffer b : origs) {
            bbs.add(this.getLengthHeader(b));
            bbs.add(b);
        }
        return ChannelBuffers.wrappedBuffer((ByteBuffer[])bbs.toArray(new ByteBuffer[bbs.size()]));
    }

    private ByteBuffer getPackHeader(RpcDataPack dataPack) {
        ByteBuffer header = ByteBuffer.allocate(12);
        header.putInt(-8391426);
        header.putInt(dataPack.getSerialNo());
        header.putInt(dataPack.getDataLst().size());
        header.flip();
        return header;
    }

    private ByteBuffer getLengthHeader(ByteBuffer buf) {
        ByteBuffer header = ByteBuffer.allocate(4);
        header.putInt(buf.limit());
        header.flip();
        return header;
    }
}

