/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.corerpc.utils;

import java.lang.reflect.Constructor;
import org.apache.inlong.tubemq.corebase.utils.TStringUtils;
import org.apache.inlong.tubemq.corerpc.exception.RemoteException;

public class MixUtils {
    public static String replaceClassNamePrefix(String className, boolean toOldVersion, int toPotocolVer) {
        if (toPotocolVer == 1) {
            if (toOldVersion) {
                return className.replace("org.apache.inlong.tubemq.", "com.tencent.tubemq.");
            }
            return className.replace("com.tencent.tubemq.", "org.apache.inlong.tubemq.");
        }
        if (toPotocolVer == 2) {
            if (toOldVersion) {
                return className.replace("org.apache.inlong.tubemq.", "com.apache.tubemq.");
            }
            return className.replace("com.apache.tubemq.", "org.apache.inlong.tubemq.");
        }
        return className;
    }

    public static Throwable unwrapException(String exceptionMsg) {
        try {
            Constructor<?> ctor;
            Class<?> clazz;
            String[] strExceptionMsgSet = exceptionMsg.split("#");
            if (strExceptionMsgSet.length > 0 && !TStringUtils.isBlank(strExceptionMsgSet[0]) && (clazz = Class.forName(strExceptionMsgSet[0])) != null && (ctor = clazz.getConstructor(String.class)) != null) {
                if (strExceptionMsgSet.length == 1) {
                    return (Throwable)ctor.newInstance(new Object[0]);
                }
                if (strExceptionMsgSet[0].equalsIgnoreCase("java.lang.NullPointerException")) {
                    return new NullPointerException("remote return null");
                }
                if (strExceptionMsgSet[1] == null || TStringUtils.isBlank(strExceptionMsgSet[1]) || strExceptionMsgSet[1].equalsIgnoreCase("null")) {
                    return (Throwable)ctor.newInstance("Exception with null StackTrace content");
                }
                return (Throwable)ctor.newInstance(strExceptionMsgSet[1]);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new RemoteException(exceptionMsg);
    }
}

