/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.corerpc.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManagerFactory;

public class TSSLEngineUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SSLEngine createSSLEngine(InputStream keyStoreStream, String keyStorePassword, InputStream trustStoreStream, String trustStorePassword, boolean isClientMode, boolean needTwyWayAuth) throws Exception {
        KeyManagerFactory kmf = null;
        TrustManagerFactory tmf = null;
        if (isClientMode || needTwyWayAuth) {
            KeyStore ts = KeyStore.getInstance("JKS");
            try {
                ts.load(trustStoreStream, trustStorePassword.toCharArray());
                tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                tmf.init(ts);
            }
            finally {
                if (trustStoreStream != null) {
                    trustStoreStream.close();
                }
            }
        }
        if (!isClientMode || needTwyWayAuth) {
            KeyStore ks = KeyStore.getInstance("JKS");
            try {
                ks.load(keyStoreStream, keyStorePassword.toCharArray());
                kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                kmf.init(ks, keyStorePassword.toCharArray());
            }
            finally {
                if (keyStoreStream != null) {
                    keyStoreStream.close();
                }
            }
        }
        SSLContext serverContext = SSLContext.getInstance("TLS");
        serverContext.init(kmf == null ? null : kmf.getKeyManagers(), tmf == null ? null : tmf.getTrustManagers(), null);
        SSLEngine sslEngine = serverContext.createSSLEngine();
        sslEngine.setUseClientMode(isClientMode);
        sslEngine.setNeedClientAuth(needTwyWayAuth);
        return sslEngine;
    }

    public static SSLEngine createSSLEngine(String keyStorePath, String trustStorePath, String keyStorePassword, String trustStorePassword, boolean isClientMode, boolean needTwyWayAuth) throws Exception {
        FileInputStream keyStoreStream = new FileInputStream(new File(keyStorePath));
        FileInputStream trustStoreStream = new FileInputStream(new File(trustStorePath));
        return TSSLEngineUtil.createSSLEngine(keyStoreStream, keyStorePassword, trustStoreStream, trustStorePassword, isClientMode, needTwyWayAuth);
    }
}

