/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.corerpc.client;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.inlong.tubemq.corerpc.client.Callback;

public class CallFuture<T>
implements Future<T>,
Callback<T> {
    private final CountDownLatch latch = new CountDownLatch(1);
    private final Callback<T> chainedCallback;
    private T result = null;
    private Throwable error = null;

    public CallFuture() {
        this(null);
    }

    public CallFuture(Callback<T> chainedCallback) {
        this.chainedCallback = chainedCallback;
    }

    @Override
    public void handleResult(T result) {
        this.result = result;
        this.latch.countDown();
        if (this.chainedCallback != null) {
            this.chainedCallback.handleResult(result);
        }
    }

    @Override
    public void handleError(Throwable error) {
        this.error = error;
        this.latch.countDown();
        if (this.chainedCallback != null) {
            this.chainedCallback.handleError(error);
        }
    }

    public T getResult() {
        return this.result;
    }

    public Throwable getError() {
        return this.error;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        this.latch.await();
        if (this.error != null) {
            throw new ExecutionException(this.error);
        }
        return this.result;
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.latch.await(timeout, unit)) {
            if (this.error != null) {
                throw new ExecutionException(this.error);
            }
            return this.result;
        }
        throw new TimeoutException();
    }

    public void await() throws InterruptedException {
        this.latch.await();
    }

    public void await(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        if (!this.latch.await(timeout, unit)) {
            throw new TimeoutException();
        }
    }

    @Override
    public boolean isDone() {
        return this.latch.getCount() <= 0L;
    }
}

