/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.corebase.daemon;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.inlong.tubemq.corebase.daemon.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDaemonService
implements Service,
Runnable {
    private static final Logger logger = LoggerFactory.getLogger(AbstractDaemonService.class);
    private final String name;
    private final long intervalMs;
    private final Thread daemon;
    private final AtomicBoolean shutdown = new AtomicBoolean(false);

    public AbstractDaemonService(String serviceName, long intervalMs) {
        this.name = serviceName;
        this.intervalMs = intervalMs;
        this.daemon = new Thread((Runnable)this, serviceName + "-daemon-thread");
        this.daemon.setDaemon(true);
    }

    @Override
    public void run() {
        logger.info(new StringBuilder(256).append(this.name).append("-daemon-thread started").toString());
        this.loopProcess(this.intervalMs);
        logger.info(new StringBuilder(256).append(this.name).append("-daemon-thread stopped").toString());
    }

    protected abstract void loopProcess(long var1);

    @Override
    public void start() {
        this.daemon.start();
    }

    @Override
    public boolean isStopped() {
        return this.shutdown.get();
    }

    @Override
    public boolean stop() {
        if (this.shutdown.get()) {
            return true;
        }
        if (this.shutdown.compareAndSet(false, true)) {
            logger.info(new StringBuilder(256).append(this.name).append("-daemon-thread closing ......").toString());
            try {
                if (this.daemon != null) {
                    this.daemon.interrupt();
                    this.daemon.join();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            logger.info(new StringBuilder(256).append(this.name).append("-daemon-thread stopped!").toString());
            return false;
        }
        return true;
    }
}

