/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.isis.applib.fixturescripts.FixtureScript;
import org.reflections.vfs.SystemDir;
import org.reflections.vfs.Vfs;

public interface AppManifest {
    public List<Class<?>> getModules();

    public List<Class<?>> getAdditionalServices();

    public String getAuthenticationMechanism();

    public String getAuthorizationMechanism();

    public List<Class<? extends FixtureScript>> getFixtures();

    public Map<String, String> getConfigurationProperties();

    public static class Util {
        public static final String ISIS_PERSISTOR = "isis.persistor.";
        public static final String ISIS_PERSISTOR_DATANUCLEUS = "isis.persistor.datanucleus.";
        public static final String ISIS_PERSISTOR_DATANUCLEUS_IMPL = "isis.persistor.datanucleus.impl.";

        public static Map<String, String> withJavaxJdoRunInMemoryProperties(Map<String, String> map) {
            map.put("isis.persistor.datanucleus.impl.javax.jdo.option.ConnectionURL", "jdbc:hsqldb:mem:test");
            map.put("isis.persistor.datanucleus.impl.javax.jdo.option.ConnectionDriverName", "org.hsqldb.jdbcDriver");
            map.put("isis.persistor.datanucleus.impl.javax.jdo.option.ConnectionUserName", "sa");
            map.put("isis.persistor.datanucleus.impl.javax.jdo.option.ConnectionPassword", "");
            return map;
        }

        public static Map<String, String> withDataNucleusProperties(Map<String, String> map) {
            map.put("isis.persistor.datanucleus.impl.datanucleus.schema.autoCreateAll", "true");
            map.put("isis.persistor.datanucleus.impl.datanucleus.schema.validateAll", "false");
            map.put("isis.persistor.datanucleus.impl.datanucleus.persistenceByReachabilityAtCommit", "false");
            map.put("isis.persistor.datanucleus.impl.datanucleus.identifier.case", "MixedCase");
            map.put("isis.persistor.datanucleus.impl.datanucleus.cache.level2.type", "none");
            map.put("isis.persistor.datanucleus.impl.datanucleus.cache.level2.mode", "ENABLE_SELECTIVE");
            return map;
        }

        public static Map<String, String> withIsisIntegTestProperties(Map<String, String> map) {
            map.put("isis.persistor.datanucleus.install-fixtures", "true");
            map.put("isis.persistor.enforceSafeSemantics", "false");
            map.put("isis.deploymentType", "server_prototype");
            map.put("isis.services.eventbus.allowLateRegistration", "true");
            return map;
        }
    }

    public static class Registry {
        public static final List<String> FRAMEWORK_PROVIDED_SERVICES = Collections.unmodifiableList(Arrays.asList("org.apache.isis.applib", "org.apache.isis.core.wrapper", "org.apache.isis.core.metamodel.services", "org.apache.isis.core.runtime.services", "org.apache.isis.schema.services", "org.apache.isis.objectstore.jdo.applib.service", "org.apache.isis.viewer.restfulobjects.rendering.service", "org.apache.isis.objectstore.jdo.datanucleus.service.support", "org.apache.isis.objectstore.jdo.datanucleus.service.eventbus", "org.apache.isis.viewer.wicket.viewer.services"));
        private static Registry instance = new Registry();
        private Set<Class<?>> persistenceCapableTypes;
        private Set<Class<?>> mixinTypes;
        private Set<Class<? extends FixtureScript>> fixtureScriptTypes;
        private Set<Class<?>> domainServiceTypes;

        public static Registry instance() {
            return instance;
        }

        public Set<Class<?>> getPersistenceCapableTypes() {
            return this.persistenceCapableTypes;
        }

        public void setPersistenceCapableTypes(Set<Class<?>> persistenceCapableTypes) {
            this.persistenceCapableTypes = persistenceCapableTypes;
        }

        public Set<Class<?>> getMixinTypes() {
            return this.mixinTypes;
        }

        public void setMixinTypes(Set<Class<?>> mixinTypes) {
            this.mixinTypes = mixinTypes;
        }

        public Set<Class<? extends FixtureScript>> getFixtureScriptTypes() {
            return this.fixtureScriptTypes;
        }

        public void setFixtureScriptTypes(Set<Class<? extends FixtureScript>> fixtureScriptTypes) {
            this.fixtureScriptTypes = fixtureScriptTypes;
        }

        public Set<Class<?>> getDomainServiceTypes() {
            return this.domainServiceTypes;
        }

        public void setDomainServiceTypes(Set<Class<?>> domainServiceTypes) {
            this.domainServiceTypes = domainServiceTypes;
        }

        public List<Vfs.UrlType> getUrlTypes() {
            ArrayList urlTypes = Lists.newArrayList();
            urlTypes.add(new EmptyIfFileEndingsUrlType(new String[]{".pom", ".jnilib", "QTJava.zip"}));
            urlTypes.add(new JettyConsoleUrlType());
            urlTypes.addAll(Arrays.asList(Vfs.DefaultUrlTypes.values()));
            return urlTypes;
        }

        private static class JettyConsoleUrlType
        implements Vfs.UrlType {
            private JettyConsoleUrlType() {
            }

            public boolean matches(URL url) {
                String protocol = url.getProtocol();
                String externalForm = url.toExternalForm();
                boolean matches = protocol.equals("file") && externalForm.contains("jetty-console") && externalForm.contains("-any-") && externalForm.endsWith("webapp/WEB-INF/classes/");
                return matches;
            }

            public Vfs.Dir createDir(URL url) throws Exception {
                return new SystemDir(JettyConsoleUrlType.getFile(url));
            }

            static File getFile(URL url) {
                File file;
                String path;
                try {
                    path = url.toURI().getSchemeSpecificPart();
                    file = new File(path);
                    if (file.exists()) {
                        return file;
                    }
                }
                catch (URISyntaxException e) {
                    // empty catch block
                }
                try {
                    path = URLDecoder.decode(url.getPath(), "UTF-8");
                    if (path.contains(".jar!")) {
                        path = path.substring(0, path.lastIndexOf(".jar!") + ".jar".length());
                    }
                    if ((file = new File(path)).exists()) {
                        return file;
                    }
                }
                catch (UnsupportedEncodingException e) {
                    // empty catch block
                }
                try {
                    path = url.toExternalForm();
                    if (path.startsWith("jar:")) {
                        path = path.substring("jar:".length());
                    }
                    if (path.startsWith("file:")) {
                        path = path.substring("file:".length());
                    }
                    if (path.contains(".jar!")) {
                        path = path.substring(0, path.indexOf(".jar!") + ".jar".length());
                    }
                    if ((file = new File(path)).exists()) {
                        return file;
                    }
                    file = new File(path = path.replace("%20", " "));
                    if (file.exists()) {
                        return file;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
        }

        private static class EmptyIfFileEndingsUrlType
        implements Vfs.UrlType {
            private final List<String> fileEndings;

            private EmptyIfFileEndingsUrlType(String ... fileEndings) {
                this.fileEndings = Lists.newArrayList((Object[])fileEndings);
            }

            public boolean matches(URL url) {
                String protocol = url.getProtocol();
                String externalForm = url.toExternalForm();
                if (!protocol.equals("file")) {
                    return false;
                }
                for (String fileEnding : this.fileEndings) {
                    if (!externalForm.endsWith(fileEnding)) continue;
                    return true;
                }
                return false;
            }

            public Vfs.Dir createDir(URL url) throws Exception {
                return EmptyIfFileEndingsUrlType.emptyVfsDir(url);
            }

            private static Vfs.Dir emptyVfsDir(final URL url) {
                return new Vfs.Dir(){

                    public String getPath() {
                        return url.toExternalForm();
                    }

                    public Iterable<Vfs.File> getFiles() {
                        return Collections.emptyList();
                    }

                    public void close() {
                    }
                };
            }
        }
    }
}

