/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.fixturescripts;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.isis.applib.fixturescripts.FixtureResult;
import org.apache.isis.applib.fixturescripts.FixtureScript;
import org.apache.isis.applib.fixturescripts.FixtureScripts;

public class FixtureResultList {
    private final List<FixtureResult> list = Lists.newArrayList();
    private final List<FixtureScript> fixtureScriptList = Lists.newArrayList();
    private final Map<String, FixtureResult> fixtureResultByKey = Maps.newHashMap();
    private final Map<FixtureScript, AtomicInteger> itemNumberByScript = Maps.newHashMap();
    private final FixtureScripts fixtureScripts;
    private final FixtureScript.ExecutionContext executionContext;

    FixtureResultList(FixtureScripts fixtureScripts, FixtureScript.ExecutionContext executionContext) {
        this.fixtureScripts = fixtureScripts;
        this.executionContext = executionContext;
    }

    public <T> T add(FixtureScript script, T object) {
        return this.add(script, this.nextItemFor(script), object);
    }

    public <T> T add(FixtureScript fixtureScript, String key, T object) {
        boolean firstTime = !this.fixtureScriptList.contains(fixtureScript);
        FixtureResult fixtureResult = this.fixtureScripts.newFixtureResult(fixtureScript, key, object, firstTime);
        if (fixtureResult != null) {
            this.list.add(fixtureResult);
            this.fixtureResultByKey.put(fixtureResult.getKey(), fixtureResult);
            this.executionContext.trace(fixtureResult);
            if (firstTime) {
                this.fixtureScriptList.add(fixtureScript);
            }
        }
        return object;
    }

    public List<FixtureResult> getResults() {
        return Collections.unmodifiableList(this.list);
    }

    String nextItemFor(FixtureScript script) {
        AtomicInteger atomicInteger = this.itemNumberByScript.get(script);
        if (atomicInteger == null) {
            atomicInteger = new AtomicInteger();
            this.itemNumberByScript.put(script, atomicInteger);
        }
        return "item-" + atomicInteger.incrementAndGet();
    }

    <T> T lookup(String key, Class<T> cls) {
        FixtureResult fixtureResult = this.fixtureResultByKey.get(key);
        if (fixtureResult == null) {
            return null;
        }
        Object object = fixtureResult.getObject();
        if (object == null) {
            throw new IllegalStateException("Fixture result exists but has NULL object");
        }
        if (!cls.isAssignableFrom(object.getClass())) {
            throw new IllegalStateException(String.format("Fixture result exists and contains object but is of type %s, not %s", object.getClass().getName(), cls.getName()));
        }
        return (T)object;
    }
}

