/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.fixturescripts;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.isis.applib.AbstractService;
import org.apache.isis.applib.ViewModel;
import org.apache.isis.applib.annotation.Action;
import org.apache.isis.applib.annotation.MemberOrder;
import org.apache.isis.applib.annotation.MinLength;
import org.apache.isis.applib.annotation.Optionality;
import org.apache.isis.applib.annotation.Parameter;
import org.apache.isis.applib.annotation.ParameterLayout;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.annotation.RestrictTo;
import org.apache.isis.applib.fixturescripts.ExecutionParameters;
import org.apache.isis.applib.fixturescripts.ExecutionParametersService;
import org.apache.isis.applib.fixturescripts.FixtureResult;
import org.apache.isis.applib.fixturescripts.FixtureScript;
import org.apache.isis.applib.services.bookmark.BookmarkService;
import org.apache.isis.applib.services.classdiscovery.ClassDiscoveryService;
import org.apache.isis.applib.services.classdiscovery.ClassDiscoveryService2;
import org.apache.isis.applib.services.fixturespec.FixtureScriptsSpecification;
import org.apache.isis.applib.services.memento.MementoService;
import org.apache.isis.applib.util.ObjectContracts;

public abstract class FixtureScripts
extends AbstractService {
    private FixtureScriptsSpecification specification;
    private List<FixtureScript> fixtureScriptList;
    @Inject
    private MementoService mementoService;
    @Inject
    private BookmarkService bookmarkService;
    @Inject
    private ClassDiscoveryService classDiscoveryService;
    @Inject
    private ExecutionParametersService executionParametersService;

    @Deprecated
    public FixtureScripts(String packagePrefix) {
        this(FixtureScriptsSpecification.builder(packagePrefix).build());
    }

    @Deprecated
    public FixtureScripts(String packagePrefix, MultipleExecutionStrategy multipleExecutionStrategy) {
        this(FixtureScriptsSpecification.builder(packagePrefix).with(multipleExecutionStrategy).build());
    }

    @Deprecated
    public FixtureScripts(String packagePrefix, NonPersistedObjectsStrategy nonPersistedObjectsStrategy) {
        this(FixtureScriptsSpecification.builder(packagePrefix).with(nonPersistedObjectsStrategy).build());
    }

    @Deprecated
    public FixtureScripts(String packagePrefix, NonPersistedObjectsStrategy nonPersistedObjectsStrategy, MultipleExecutionStrategy multipleExecutionStrategy) {
        this(FixtureScriptsSpecification.builder(packagePrefix).with(nonPersistedObjectsStrategy).with(multipleExecutionStrategy).build());
    }

    public FixtureScripts(FixtureScriptsSpecification specification) {
        this.specification = specification;
    }

    @Programmatic
    public FixtureScriptsSpecification getSpecification() {
        return this.specification;
    }

    protected void setSpecification(FixtureScriptsSpecification specification) {
        this.specification = specification;
    }

    @Programmatic
    public String getPackagePrefix() {
        return this.specification.getPackagePrefix();
    }

    @Programmatic
    public NonPersistedObjectsStrategy getNonPersistedObjectsStrategy() {
        return this.specification.getNonPersistedObjectsStrategy();
    }

    @Programmatic
    public MultipleExecutionStrategy getMultipleExecutionStrategy() {
        return this.specification.getMultipleExecutionStrategy();
    }

    @Programmatic
    @PostConstruct
    public void init() {
    }

    @Programmatic
    public List<FixtureScript> getFixtureScriptList() {
        if (this.fixtureScriptList == null) {
            this.fixtureScriptList = this.findAndInstantiateFixtureScripts();
        }
        return this.fixtureScriptList;
    }

    private List<FixtureScript> findAndInstantiateFixtureScripts() {
        ArrayList fixtureScripts = Lists.newArrayList();
        Set<Class<? extends FixtureScript>> fixtureScriptSubtypes = this.findFixtureScriptSubTypesInPackage();
        for (Class<? extends FixtureScript> fixtureScriptCls : fixtureScriptSubtypes) {
            FixtureScript fs;
            String packageName = fixtureScriptCls.getPackage().getName();
            if (!packageName.startsWith(this.getPackagePrefix()) || (fs = this.newFixtureScript(fixtureScriptCls)) == null) continue;
            fixtureScripts.add(fs);
        }
        Collections.sort(fixtureScripts, new Comparator<FixtureScript>(){

            @Override
            public int compare(FixtureScript o1, FixtureScript o2) {
                return ObjectContracts.compare(o1, o2, "friendlyName", "qualifiedName");
            }
        });
        return fixtureScripts;
    }

    private Set<Class<? extends FixtureScript>> findFixtureScriptSubTypesInPackage() {
        return this.findSubTypesOfClasses(FixtureScript.class, this.getPackagePrefix());
    }

    private <T> Set<Class<? extends T>> findSubTypesOfClasses(Class<T> cls, String packagePrefix) {
        if (this.classDiscoveryService instanceof ClassDiscoveryService2) {
            ClassDiscoveryService2 classDiscoveryService2 = (ClassDiscoveryService2)this.classDiscoveryService;
            return classDiscoveryService2.findSubTypesOfClasses(cls, packagePrefix);
        }
        return this.classDiscoveryService.findSubTypesOfClasses(cls);
    }

    private FixtureScript newFixtureScript(Class<? extends FixtureScript> fixtureScriptCls) {
        try {
            Constructor<? extends FixtureScript> constructor = fixtureScriptCls.getConstructor(new Class[0]);
            FixtureScript template = constructor.newInstance(new Object[0]);
            if (!template.isDiscoverable()) {
                return null;
            }
            return this.getContainer().newViewModelInstance(fixtureScriptCls, this.mementoFor(template));
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Action(restrictTo=RestrictTo.PROTOTYPING)
    @MemberOrder(sequence="10")
    public List<FixtureResult> runFixtureScript(FixtureScript fixtureScript, @ParameterLayout(named="Parameters", describedAs="Script-specific parameters (if any).  The format depends on the script implementation (eg key=value, CSV, JSON, XML etc)", multiLine=10) @Parameter(optionality=Optionality.OPTIONAL) String parameters) {
        this.getContainer().injectServicesInto(fixtureScript);
        return fixtureScript.run(parameters);
    }

    public FixtureScript default0RunFixtureScript() {
        return this.getFixtureScriptList().isEmpty() ? null : this.getFixtureScriptList().get(0);
    }

    protected List<FixtureScript> choices0RunFixtureScript() {
        return this.getFixtureScriptList();
    }

    protected List<FixtureScript> autoComplete0RunFixtureScript(final @MinLength(value=1) String arg) {
        return Lists.newArrayList((Iterable)Collections2.filter(this.getFixtureScriptList(), (Predicate)new Predicate<FixtureScript>(){

            public boolean apply(FixtureScript input) {
                return this.contains(input.getFriendlyName()) || this.contains(input.getLocalName());
            }

            private boolean contains(String str) {
                return str != null && str.contains(arg);
            }
        }));
    }

    public String disableRunFixtureScript(FixtureScript fixtureScript, String parameters) {
        return this.getFixtureScriptList().isEmpty() ? "No fixture scripts found under package '" + this.getPackagePrefix() + "'" : null;
    }

    public String validateRunFixtureScript(FixtureScript fixtureScript, String parameters) {
        return fixtureScript.validateRun(parameters);
    }

    @Programmatic
    public FixtureScript findFixtureScriptFor(Class<? extends FixtureScript> fixtureScriptClass) {
        List<FixtureScript> fixtureScripts = this.getFixtureScriptList();
        for (FixtureScript fs : fixtureScripts) {
            if (!fixtureScriptClass.isAssignableFrom(fs.getClass())) continue;
            return fs;
        }
        return null;
    }

    @Programmatic
    public FixtureScript.ExecutionContext newExecutionContext(String parameters) {
        ExecutionParameters executionParameters = this.executionParametersService != null ? this.executionParametersService.newExecutionParameters(parameters) : new ExecutionParameters(parameters);
        return FixtureScript.ExecutionContext.create(executionParameters, this);
    }

    protected FixtureScript findFixtureScriptFor(String qualifiedName) {
        List<FixtureScript> fixtureScripts = this.getFixtureScriptList();
        for (FixtureScript fs : fixtureScripts) {
            if (!fs.getQualifiedName().contains(qualifiedName)) continue;
            return fs;
        }
        return null;
    }

    String mementoFor(FixtureScript fs) {
        return this.mementoService.create().set("path", fs.getParentPath()).asString();
    }

    void initOf(String mementoStr, FixtureScript fs) {
        MementoService.Memento memento = this.mementoService.parse(mementoStr);
        fs.setParentPath(memento.get("path", String.class));
    }

    @Programmatic
    FixtureResult newFixtureResult(FixtureScript script, String subkey, Object object, boolean firstTime) {
        if (object == null) {
            return null;
        }
        if (!(object instanceof ViewModel) && !this.getContainer().isPersistent(object)) {
            switch (this.getNonPersistedObjectsStrategy()) {
                case PERSIST: {
                    this.getContainer().flush();
                    break;
                }
                case IGNORE: {
                    return null;
                }
            }
        }
        FixtureResult fixtureResult = new FixtureResult();
        fixtureResult.setFixtureScriptClassName(firstTime ? script.getClass().getName() : null);
        fixtureResult.setFixtureScriptQualifiedName(script.getQualifiedName());
        fixtureResult.setKey(script.pathWith(subkey));
        fixtureResult.setObject(object);
        return fixtureResult;
    }

    @Programmatic
    String titleOf(FixtureResult fixtureResult) {
        Object object = fixtureResult.getObject();
        return object != null ? this.getContainer().titleOf(object) : "(null)";
    }

    public static enum MultipleExecutionStrategy {
        IGNORE,
        EXECUTE_ONCE_BY_CLASS,
        EXECUTE_ONCE_BY_VALUE,
        EXECUTE;


        @Deprecated
        public boolean isIgnore() {
            return this == IGNORE;
        }

        public boolean isExecuteOnceByClass() {
            return this == EXECUTE_ONCE_BY_CLASS;
        }

        public boolean isExecuteOnceByValue() {
            return this == EXECUTE_ONCE_BY_VALUE;
        }

        public boolean isExecute() {
            return this == EXECUTE;
        }
    }

    public static enum NonPersistedObjectsStrategy {
        PERSIST,
        IGNORE;

    }
}

