/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.layout.component;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.applib.layout.component.ActionLayoutData;
import org.apache.isis.applib.layout.component.ActionLayoutDataOwner;
import org.apache.isis.applib.layout.component.CollectionLayoutDataOwner;
import org.apache.isis.applib.layout.component.HasCssClass;
import org.apache.isis.applib.layout.component.HasDescribedAs;
import org.apache.isis.applib.layout.component.HasHidden;
import org.apache.isis.applib.layout.component.HasNamed;
import org.apache.isis.applib.layout.component.MemberRegion;

@XmlRootElement(name="collection")
@XmlType(name="collection", propOrder={"named", "describedAs", "sortedBy", "actions", "metadataError"})
public class CollectionLayoutData
implements MemberRegion<CollectionLayoutDataOwner>,
ActionLayoutDataOwner,
Serializable,
HasCssClass,
HasDescribedAs,
HasHidden,
HasNamed {
    private static final long serialVersionUID = 1L;
    private String id;
    private String cssClass;
    private String describedAs;
    private String defaultView;
    private Where hidden;
    private String named;
    private Boolean namedEscaped;
    private Integer paged;
    private String sortedBy;
    private List<ActionLayoutData> actions = Lists.newArrayList();
    private CollectionLayoutDataOwner owner;
    private String metadataError;

    public CollectionLayoutData() {
    }

    public CollectionLayoutData(String id) {
        this.setId(id);
    }

    @XmlAttribute(required=true)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    @XmlAttribute(required=false)
    public String getCssClass() {
        return this.cssClass;
    }

    @Override
    public void setCssClass(String cssClass) {
        this.cssClass = cssClass;
    }

    @Override
    @XmlElement(required=false)
    public String getDescribedAs() {
        return this.describedAs;
    }

    @Override
    public void setDescribedAs(String describedAs) {
        this.describedAs = describedAs;
    }

    @XmlAttribute(required=false)
    public String getDefaultView() {
        return this.defaultView;
    }

    public void setDefaultView(String defaultView) {
        this.defaultView = defaultView;
    }

    @Override
    @XmlAttribute(required=false)
    public Where getHidden() {
        return this.hidden;
    }

    @Override
    public void setHidden(Where hidden) {
        this.hidden = hidden;
    }

    @Override
    @XmlElement(required=false)
    public String getNamed() {
        return this.named;
    }

    @Override
    public void setNamed(String named) {
        this.named = named;
    }

    @Override
    @XmlAttribute(required=false)
    public Boolean getNamedEscaped() {
        return this.namedEscaped;
    }

    @Override
    public void setNamedEscaped(Boolean namedEscaped) {
        this.namedEscaped = namedEscaped;
    }

    @XmlAttribute(required=false)
    public Integer getPaged() {
        return this.paged;
    }

    public void setPaged(Integer paged) {
        this.paged = paged;
    }

    @XmlElement(required=false)
    public String getSortedBy() {
        return this.sortedBy;
    }

    public void setSortedBy(String sortedBy) {
        this.sortedBy = sortedBy;
    }

    @Override
    @XmlElement(name="action", required=false)
    public List<ActionLayoutData> getActions() {
        return this.actions;
    }

    @Override
    public void setActions(List<ActionLayoutData> actionLayoutDatas) {
        this.actions = actionLayoutDatas;
    }

    @Override
    @XmlTransient
    public CollectionLayoutDataOwner getOwner() {
        return this.owner;
    }

    public void setOwner(CollectionLayoutDataOwner owner) {
        this.owner = owner;
    }

    @XmlElement(required=false)
    public String getMetadataError() {
        return this.metadataError;
    }

    public void setMetadataError(String metadataError) {
        this.metadataError = metadataError;
    }

    public String toString() {
        return "CollectionLayoutData{id='" + this.id + '\'' + '}';
    }

    public static class Functions {
        private Functions() {
        }

        public static Function<CollectionLayoutData, String> id() {
            return new Function<CollectionLayoutData, String>(){

                public String apply(CollectionLayoutData metadata) {
                    return metadata.getId();
                }
            };
        }
    }
}

