/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.layout.component;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.List;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.layout.component.ActionLayoutData;
import org.apache.isis.applib.layout.component.ActionLayoutDataOwner;
import org.apache.isis.applib.layout.component.CollectionLayoutData;
import org.apache.isis.applib.layout.component.CollectionLayoutDataOwner;
import org.apache.isis.applib.layout.component.FieldSet;
import org.apache.isis.applib.layout.component.FieldSetOwner;
import org.apache.isis.applib.layout.component.Grid;
import org.apache.isis.applib.layout.component.PropertyLayoutData;
import org.apache.isis.applib.layout.grid.bootstrap3.BS3Grid;

@XmlTransient
public abstract class GridAbstract
implements Grid {
    private Class<?> domainClass;
    private String tnsAndSchemaLocation;
    private boolean normalized;

    @Override
    @Programmatic
    @XmlTransient
    public Class<?> getDomainClass() {
        return this.domainClass;
    }

    @Override
    @Programmatic
    public void setDomainClass(Class<?> domainClass) {
        this.domainClass = domainClass;
    }

    @Override
    @Programmatic
    @XmlTransient
    public String getTnsAndSchemaLocation() {
        return this.tnsAndSchemaLocation;
    }

    @Override
    @Programmatic
    public void setTnsAndSchemaLocation(String tnsAndSchemaLocation) {
        this.tnsAndSchemaLocation = tnsAndSchemaLocation;
    }

    @Override
    @Programmatic
    @XmlTransient
    public boolean isNormalized() {
        return this.normalized;
    }

    @Override
    @Programmatic
    public void setNormalized(boolean normalized) {
        this.normalized = normalized;
    }

    protected void traverseActions(ActionLayoutDataOwner actionLayoutDataOwner, Grid.Visitor visitor) {
        List<ActionLayoutData> actionLayoutDatas = actionLayoutDataOwner.getActions();
        if (actionLayoutDatas == null) {
            return;
        }
        for (ActionLayoutData actionLayoutData : Lists.newArrayList(actionLayoutDatas)) {
            actionLayoutData.setOwner(actionLayoutDataOwner);
            visitor.visit(actionLayoutData);
        }
    }

    protected void traverseFieldSets(FieldSetOwner fieldSetOwner, Grid.Visitor visitor) {
        List<FieldSet> fieldSets = fieldSetOwner.getFieldSets();
        for (FieldSet fieldSet : Lists.newArrayList(fieldSets)) {
            fieldSet.setOwner(fieldSetOwner);
            visitor.visit(fieldSet);
            this.traverseActions(fieldSet, visitor);
            List<PropertyLayoutData> properties = fieldSet.getProperties();
            for (PropertyLayoutData property : Lists.newArrayList(properties)) {
                property.setOwner(fieldSet);
                visitor.visit(property);
                this.traverseActions(property, visitor);
            }
        }
    }

    protected void traverseCollections(CollectionLayoutDataOwner owner, Grid.Visitor visitor) {
        List<CollectionLayoutData> collections = owner.getCollections();
        for (CollectionLayoutData collection : Lists.newArrayList(collections)) {
            collection.setOwner(owner);
            visitor.visit(collection);
            this.traverseActions(collection, visitor);
        }
    }

    @Override
    @Programmatic
    @XmlTransient
    public LinkedHashMap<String, PropertyLayoutData> getAllPropertiesById() {
        final LinkedHashMap propertiesById = Maps.newLinkedHashMap();
        this.visit(new BS3Grid.VisitorAdapter(){

            @Override
            public void visit(PropertyLayoutData propertyLayoutData) {
                propertiesById.put(propertyLayoutData.getId(), propertyLayoutData);
            }
        });
        return propertiesById;
    }

    @Override
    @Programmatic
    @XmlTransient
    public LinkedHashMap<String, CollectionLayoutData> getAllCollectionsById() {
        final LinkedHashMap collectionsById = Maps.newLinkedHashMap();
        this.visit(new BS3Grid.VisitorAdapter(){

            @Override
            public void visit(CollectionLayoutData collectionLayoutData) {
                collectionsById.put(collectionLayoutData.getId(), collectionLayoutData);
            }
        });
        return collectionsById;
    }

    @Override
    @Programmatic
    @XmlTransient
    public LinkedHashMap<String, ActionLayoutData> getAllActionsById() {
        final LinkedHashMap actionsById = Maps.newLinkedHashMap();
        this.visit(new BS3Grid.VisitorAdapter(){

            @Override
            public void visit(ActionLayoutData actionLayoutData) {
                actionsById.put(actionLayoutData.getId(), actionLayoutData);
            }
        });
        return actionsById;
    }

    @Programmatic
    @XmlTransient
    public LinkedHashMap<String, FieldSet> getAllFieldSetsByName() {
        final LinkedHashMap fieldSetsByName = Maps.newLinkedHashMap();
        this.visit(new BS3Grid.VisitorAdapter(){

            @Override
            public void visit(FieldSet fieldSet) {
                fieldSetsByName.put(fieldSet.getName(), fieldSet);
            }
        });
        return fieldSetsByName;
    }
}

