/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.bookmark;

import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.isis.applib.Identifier;
import org.apache.isis.applib.IsisApplibModule;
import org.apache.isis.applib.annotation.Action;
import org.apache.isis.applib.annotation.ActionLayout;
import org.apache.isis.applib.annotation.Contributed;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.annotation.SemanticsOf;
import org.apache.isis.applib.services.bookmark.BookmarkHolder;
import org.apache.isis.applib.services.bookmark.BookmarkService;

@DomainService(nature=NatureOfService.VIEW_CONTRIBUTIONS_ONLY)
public class BookmarkHolderActionContributions {
    @Inject
    private BookmarkService bookmarkService;

    @Programmatic
    @PostConstruct
    public void init(Map<String, String> props) {
        this.ensureDependenciesInjected();
    }

    private void ensureDependenciesInjected() {
        if (this.bookmarkService == null) {
            throw new IllegalStateException("BookmarkService domain service must be configured");
        }
    }

    @Action(domainEvent=LookupDomainEvent.class, semantics=SemanticsOf.SAFE)
    @ActionLayout(contributed=Contributed.AS_ACTION, cssClassFa="fa-bookmark")
    public Object lookup(BookmarkHolder bookmarkHolder) {
        return this.bookmarkService.lookup(bookmarkHolder);
    }

    public static class LookupDomainEvent
    extends ActionDomainEvent {
        public LookupDomainEvent(BookmarkHolderActionContributions source, Identifier identifier, Object ... arguments) {
            super(source, identifier, arguments);
        }
    }

    public static abstract class ActionDomainEvent
    extends IsisApplibModule.ActionDomainEvent<BookmarkHolderActionContributions> {
        public ActionDomainEvent(BookmarkHolderActionContributions source, Identifier identifier) {
            super(source, identifier);
        }

        public ActionDomainEvent(BookmarkHolderActionContributions source, Identifier identifier, Object ... arguments) {
            super(source, identifier, arguments);
        }

        public ActionDomainEvent(BookmarkHolderActionContributions source, Identifier identifier, List<Object> arguments) {
            super(source, identifier, arguments);
        }
    }
}

