/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.bookmark;

import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.isis.applib.Identifier;
import org.apache.isis.applib.IsisApplibModule;
import org.apache.isis.applib.annotation.Action;
import org.apache.isis.applib.annotation.ActionLayout;
import org.apache.isis.applib.annotation.Contributed;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.annotation.Property;
import org.apache.isis.applib.annotation.SemanticsOf;
import org.apache.isis.applib.services.bookmark.BookmarkHolder;
import org.apache.isis.applib.services.bookmark.BookmarkService;

@DomainService(nature=NatureOfService.VIEW_CONTRIBUTIONS_ONLY)
public class BookmarkHolderAssociationContributions {
    @Inject
    private BookmarkService bookmarkService;

    @Programmatic
    @PostConstruct
    public void init(Map<String, String> props) {
        this.ensureDependenciesInjected();
    }

    private void ensureDependenciesInjected() {
        if (this.bookmarkService == null) {
            throw new IllegalStateException("BookmarkService domain service must be configured");
        }
    }

    @Action(semantics=SemanticsOf.SAFE)
    @ActionLayout(contributed=Contributed.AS_ASSOCIATION)
    @Property(domainEvent=ObjectDomainEvent.class)
    public Object object(BookmarkHolder bookmarkHolder) {
        return this.bookmarkService.lookup(bookmarkHolder);
    }

    public static class ObjectDomainEvent
    extends PropertyDomainEvent<Object> {
        public ObjectDomainEvent(BookmarkHolderAssociationContributions source, Identifier identifier) {
            super(source, identifier);
        }

        public ObjectDomainEvent(BookmarkHolderAssociationContributions source, Identifier identifier, Object oldValue, Object newValue) {
            super(source, identifier, oldValue, newValue);
        }
    }

    public static abstract class PropertyDomainEvent<T>
    extends IsisApplibModule.PropertyDomainEvent<BookmarkHolderAssociationContributions, T> {
        public PropertyDomainEvent(BookmarkHolderAssociationContributions source, Identifier identifier) {
            super(source, identifier);
        }

        public PropertyDomainEvent(BookmarkHolderAssociationContributions source, Identifier identifier, T oldValue, T newValue) {
            super(source, identifier, oldValue, newValue);
        }
    }
}

