/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.dto;

import javax.inject.Inject;
import org.apache.isis.applib.IsisApplibModule;
import org.apache.isis.applib.annotation.Action;
import org.apache.isis.applib.annotation.ActionLayout;
import org.apache.isis.applib.annotation.MemberOrder;
import org.apache.isis.applib.annotation.Mixin;
import org.apache.isis.applib.annotation.ParameterLayout;
import org.apache.isis.applib.annotation.RestrictTo;
import org.apache.isis.applib.annotation.SemanticsOf;
import org.apache.isis.applib.services.dto.Dto;
import org.apache.isis.applib.services.dto.Util;
import org.apache.isis.applib.services.jaxb.JaxbService;
import org.apache.isis.applib.value.Clob;

@Mixin
public class Dto_downloadXml {
    private final Dto dto;
    @Inject
    JaxbService jaxbService;

    public Dto_downloadXml(Dto dto) {
        this.dto = dto;
    }

    @Action(domainEvent=ActionDomainEvent.class, semantics=SemanticsOf.SAFE, restrictTo=RestrictTo.PROTOTYPING)
    @ActionLayout(cssClassFa="fa-download")
    @MemberOrder(sequence="500.1")
    public Object $$(@ParameterLayout(named="File name") String fileName) {
        String xml = this.jaxbService.toXml(this.dto);
        return new Clob(Util.withSuffix(fileName, "xml"), "text/xml", (CharSequence)xml);
    }

    public String default0$$() {
        return Util.withSuffix(this.dto.getClass().getName(), "xml");
    }

    public static class ActionDomainEvent
    extends IsisApplibModule.ActionDomainEvent<Dto_downloadXml> {
    }
}

