/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.eventbus;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.services.eventbus.EventBusImplementation;

public abstract class EventBusService {
    public static final EventBusService NOOP = new Noop();
    private final Set<Object> subscribers = Sets.newConcurrentHashSet();
    protected EventBusImplementation eventBusImplementation;
    private Set<Object> registeredSubscribers;

    @Programmatic
    @PostConstruct
    public void init(Map<String, String> properties) {
    }

    @Programmatic
    @PreDestroy
    public void shutdown() {
        this.teardownEventBus();
    }

    @Programmatic
    public void register(Object domainService) {
        this.doRegister(domainService);
    }

    protected void doRegister(Object domainService) {
        if (this.eventBusImplementation == null) {
            this.subscribers.add(domainService);
        } else {
            this.eventBusImplementation.register(domainService);
        }
    }

    @Programmatic
    public void unregister(Object domainService) {
    }

    @Programmatic
    public Set<Object> getSubscribers() {
        return Collections.unmodifiableSet(Sets.newLinkedHashSet(this.subscribers));
    }

    @Programmatic
    public void post(Object event) {
        if (this.skip(event)) {
            return;
        }
        this.getEventBusImplementation().post(event);
    }

    protected boolean hasPosted() {
        return this.eventBusImplementation != null;
    }

    @Programmatic
    protected EventBusImplementation getEventBusImplementation() {
        this.setupEventBus();
        return this.eventBusImplementation;
    }

    protected void setupEventBus() {
        if (this.eventBusImplementation != null) {
            return;
        }
        this.eventBusImplementation = this.newEventBus();
        this.registeredSubscribers = this.getSubscribers();
        for (Object subscriber : this.registeredSubscribers) {
            this.eventBusImplementation.register(subscriber);
        }
    }

    protected void teardownEventBus() {
        if (this.registeredSubscribers != null) {
            for (Object subscriber : this.registeredSubscribers) {
                this.eventBusImplementation.unregister(subscriber);
            }
        }
        this.eventBusImplementation = null;
    }

    protected abstract EventBusImplementation newEventBus();

    protected boolean skip(Object event) {
        return false;
    }

    public static class Noop
    extends EventBusService {
        @Override
        public void register(Object domainService) {
        }

        @Override
        public void unregister(Object domainService) {
        }

        @Override
        public void post(Object event) {
        }

        @Override
        protected EventBusImplementation getEventBusImplementation() {
            return null;
        }

        @Override
        protected EventBusImplementation newEventBus() {
            return null;
        }
    }
}

