/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.layout;

import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import javax.inject.Inject;
import org.apache.isis.applib.IsisApplibModule;
import org.apache.isis.applib.annotation.Action;
import org.apache.isis.applib.annotation.ActionLayout;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.DomainServiceLayout;
import org.apache.isis.applib.annotation.MemberOrder;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.RestrictTo;
import org.apache.isis.applib.annotation.SemanticsOf;
import org.apache.isis.applib.services.layout.LayoutService;
import org.apache.isis.applib.value.Blob;

@DomainService(nature=NatureOfService.VIEW_MENU_ONLY)
@DomainServiceLayout(named="Prototyping", menuBar=DomainServiceLayout.MenuBar.SECONDARY, menuOrder="500.400")
public class LayoutServiceMenu {
    private final MimeType mimeTypeApplicationZip;
    @Inject
    LayoutService layoutService;

    public LayoutServiceMenu() {
        try {
            this.mimeTypeApplicationZip = new MimeType("application", "zip");
        }
        catch (MimeTypeParseException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Action(domainEvent=DownloadLayoutsDomainEvent.class, semantics=SemanticsOf.SAFE, restrictTo=RestrictTo.PROTOTYPING)
    @ActionLayout(cssClassFa="fa-download", named="Download Layouts (XML)")
    @MemberOrder(sequence="500.400.1")
    public Blob downloadLayouts(LayoutService.Style style) {
        String fileName = "layouts." + style.name().toLowerCase() + ".zip";
        byte[] zipBytes = this.layoutService.toZip(style);
        return new Blob(fileName, this.mimeTypeApplicationZip, zipBytes);
    }

    public LayoutService.Style default0DownloadLayouts() {
        return LayoutService.Style.NORMALIZED;
    }

    public static class DownloadLayoutsDomainEvent
    extends ActionDomainEvent {
    }

    public static abstract class ActionDomainEvent
    extends IsisApplibModule.ActionDomainEvent<LayoutServiceMenu> {
    }
}

