/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.layout;

import javax.inject.Inject;
import org.apache.isis.applib.IsisApplibModule;
import org.apache.isis.applib.annotation.Action;
import org.apache.isis.applib.annotation.ActionLayout;
import org.apache.isis.applib.annotation.MemberOrder;
import org.apache.isis.applib.annotation.Mixin;
import org.apache.isis.applib.annotation.ParameterLayout;
import org.apache.isis.applib.annotation.RestrictTo;
import org.apache.isis.applib.annotation.SemanticsOf;
import org.apache.isis.applib.services.jaxb.JaxbService;
import org.apache.isis.applib.services.layout.LayoutService;
import org.apache.isis.applib.services.layout.Util;
import org.apache.isis.applib.value.Clob;

@Mixin
public class Object_downloadLayoutXml {
    private final Object object;
    @Inject
    LayoutService layoutService;
    @Inject
    JaxbService jaxbService;

    public Object_downloadLayoutXml(Object object) {
        this.object = object;
    }

    @Action(domainEvent=ActionDomainEvent.class, semantics=SemanticsOf.SAFE, restrictTo=RestrictTo.PROTOTYPING)
    @ActionLayout(cssClassFa="fa-download", position=ActionLayout.Position.PANEL_DROPDOWN)
    @MemberOrder(name="Metadata", sequence="700.1")
    public Object $$(@ParameterLayout(named="File name") String fileName, LayoutService.Style style) {
        String xml = this.layoutService.toXml(this.object.getClass(), style);
        return new Clob(Util.withSuffix(fileName, style.name().toLowerCase() + ".xml"), "text/xml", (CharSequence)xml);
    }

    public String default0$$() {
        return Util.withSuffix(this.object.getClass().getSimpleName(), "layout");
    }

    public LayoutService.Style default1$$() {
        return LayoutService.Style.NORMALIZED;
    }

    public static class ActionDomainEvent
    extends IsisApplibModule.ActionDomainEvent<Object_downloadLayoutXml> {
    }
}

