/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.metamodel;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import javax.inject.Inject;
import org.apache.isis.applib.IsisApplibModule;
import org.apache.isis.applib.annotation.Action;
import org.apache.isis.applib.annotation.ActionLayout;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.DomainServiceLayout;
import org.apache.isis.applib.annotation.MemberOrder;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.ParameterLayout;
import org.apache.isis.applib.annotation.RestrictTo;
import org.apache.isis.applib.annotation.SemanticsOf;
import org.apache.isis.applib.services.metamodel.DomainMember;
import org.apache.isis.applib.services.metamodel.MetaModelService;
import org.apache.isis.applib.services.metamodel.Util;
import org.apache.isis.applib.value.Clob;

@DomainService(nature=NatureOfService.VIEW_MENU_ONLY)
@DomainServiceLayout(named="Prototyping", menuBar=DomainServiceLayout.MenuBar.SECONDARY, menuOrder="500.500")
public class MetaModelServicesMenu {
    private final MimeType mimeTypeTextCsv;
    @Inject
    MetaModelService metaModelService;

    public MetaModelServicesMenu() {
        try {
            this.mimeTypeTextCsv = new MimeType("text", "csv");
        }
        catch (MimeTypeParseException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Action(domainEvent=DownloadMetaModelEvent.class, semantics=SemanticsOf.SAFE, restrictTo=RestrictTo.PROTOTYPING)
    @ActionLayout(cssClassFa="fa-download", named="Download Meta Model (CSV)")
    @MemberOrder(sequence="500.500.1")
    public Clob downloadMetaModel(@ParameterLayout(named=".csv file name") String csvFileName) {
        List<DomainMember> rows = this.metaModelService.export();
        List<String> list = MetaModelServicesMenu.asList(rows);
        StringBuilder buf = MetaModelServicesMenu.asBuf(list);
        return new Clob(Util.withSuffix(csvFileName, "csv"), this.mimeTypeTextCsv, buf.toString().toCharArray());
    }

    public String default0DownloadMetaModel() {
        return "metamodel.csv";
    }

    private static StringBuilder asBuf(List<String> list) {
        StringBuilder buf = new StringBuilder();
        for (String row : list) {
            buf.append(row).append("\n");
        }
        return buf;
    }

    private static List<String> asList(List<DomainMember> rows) {
        ArrayList list = Lists.newArrayList();
        list.add(MetaModelServicesMenu.header());
        for (DomainMember row : rows) {
            list.add(MetaModelServicesMenu.asTextCsv(row));
        }
        return list;
    }

    private static String header() {
        return "classType,packageName,className,memberType,memberName,numParams,contributed?,contributedBy,mixedIn?,mixin,hidden,disabled,choices,autoComplete,default,validate";
    }

    private static String asTextCsv(DomainMember row) {
        return Joiner.on((String)",").join((Object)row.getClassType(), (Object)row.getPackageName(), new Object[]{row.getClassName(), row.getType(), row.getMemberName(), row.getNumParams(), row.isContributed() ? "Y" : "", row.getContributedBy(), row.isMixedIn() ? "Y" : "", row.getMixin(), row.getHidden(), row.getDisabled(), row.getChoices(), row.getAutoComplete(), row.getDefault(), row.getValidate()});
    }

    public static class DownloadMetaModelEvent
    extends ActionDomainEvent {
    }

    public static abstract class ActionDomainEvent
    extends IsisApplibModule.ActionDomainEvent<MetaModelServicesMenu> {
    }
}

