/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.wrapper;

import java.util.Collections;
import java.util.List;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.events.InteractionEvent;
import org.apache.isis.applib.services.wrapper.listeners.InteractionListener;

public interface WrapperFactory {
    public static final WrapperFactory NOOP = new WrapperFactory(){

        @Override
        public <T> T wrap(T domainObject) {
            return domainObject;
        }

        @Override
        public <T> T wrapNoExecute(T domainObject) {
            return domainObject;
        }

        @Override
        public <T> T wrapSkipRules(T domainObject) {
            return domainObject;
        }

        @Override
        public <T> T wrap(T domainObject, ExecutionMode mode) {
            return domainObject;
        }

        @Override
        public <T> T unwrap(T possibleWrappedDomainObject) {
            return possibleWrappedDomainObject;
        }

        @Override
        public <T> boolean isWrapper(T possibleWrappedDomainObject) {
            return false;
        }

        @Override
        public List<InteractionListener> getListeners() {
            return Collections.emptyList();
        }

        @Override
        public boolean addInteractionListener(InteractionListener listener) {
            return false;
        }

        @Override
        public boolean removeInteractionListener(InteractionListener listener) {
            return false;
        }

        @Override
        public void notifyListeners(InteractionEvent ev) {
        }
    };

    @Programmatic
    public <T> T wrap(T var1);

    @Programmatic
    public <T> T wrapNoExecute(T var1);

    @Programmatic
    public <T> T wrapSkipRules(T var1);

    @Programmatic
    public <T> T wrap(T var1, ExecutionMode var2);

    @Programmatic
    public <T> T unwrap(T var1);

    @Programmatic
    public <T> boolean isWrapper(T var1);

    @Programmatic
    public List<InteractionListener> getListeners();

    @Programmatic
    public boolean addInteractionListener(InteractionListener var1);

    @Programmatic
    public boolean removeInteractionListener(InteractionListener var1);

    @Programmatic
    public void notifyListeners(InteractionEvent var1);

    public static enum ExecutionMode {
        EXECUTE(true, true),
        SKIP_RULES(false, true),
        NO_EXECUTE(true, false);

        private final boolean enforceRules;
        private final boolean execute;

        private ExecutionMode(boolean enforceRules, boolean execute) {
            this.enforceRules = enforceRules;
            this.execute = execute;
        }

        public boolean shouldEnforceRules() {
            return this.enforceRules;
        }

        public boolean shouldExecute() {
            return this.execute;
        }
    }
}

