/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.util;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.isis.applib.util.Clause;

public class ObjectContracts {
    private final List<ToStringEvaluator> evaluators = Lists.newArrayList();

    @Deprecated
    public static <T> int compare(T p, T q, String propertyNames) {
        Iterable<String> propertyNamesIter = ObjectContracts.csvToIterable(propertyNames);
        return ObjectContracts.compare(p, q, propertyNamesIter);
    }

    @Deprecated
    public static <T> int compare(T p, T q, String ... propertyNames) {
        List<String> propertyNamesIter = ObjectContracts.varargsToIterable(propertyNames);
        return ObjectContracts.compare(p, q, propertyNamesIter);
    }

    private static <T> int compare(T p, T q, Iterable<String> propertyNamesIter) {
        Iterable<Clause> clauses = ObjectContracts.clausesFor(propertyNamesIter);
        ComparisonChain chain = ComparisonChain.start();
        for (Clause clause : clauses) {
            Comparable propertyValueOfP = (Comparable)clause.getValueOf(p);
            Comparable propertyValueOfQ = (Comparable)clause.getValueOf(q);
            chain = chain.compare((Object)propertyValueOfP, (Object)propertyValueOfQ, clause.getDirection().getOrdering());
        }
        return chain.result();
    }

    @Deprecated
    public static <T> Comparator<T> compareBy(final String propertyNames) {
        return new Comparator<T>(){

            @Override
            public int compare(T p, T q) {
                return ObjectContracts.compare(p, q, propertyNames);
            }
        };
    }

    @Deprecated
    public static <T> Comparator<T> compareBy(final String ... propertyNames) {
        return new Comparator<T>(){

            @Override
            public int compare(T p, T q) {
                return ObjectContracts.compare(p, q, propertyNames);
            }
        };
    }

    @Deprecated
    public static String toString(Object p, String propertyNames) {
        return new ObjectContracts().toStringOf(p, propertyNames);
    }

    @Deprecated
    public static String toString(Object p, String ... propertyNames) {
        return new ObjectContracts().toStringOf(p, propertyNames);
    }

    @Deprecated
    public static int hashCode(Object obj, String propertyNames) {
        Iterable<String> propertyNamesIter = ObjectContracts.csvToIterable(propertyNames);
        return ObjectContracts.hashCode(obj, propertyNamesIter);
    }

    @Deprecated
    public static int hashCode(Object obj, String ... propertyNames) {
        List<String> propertyNamesIter = ObjectContracts.varargsToIterable(propertyNames);
        return ObjectContracts.hashCode(obj, propertyNamesIter);
    }

    private static int hashCode(Object obj, Iterable<String> propertyNamesIter) {
        ArrayList propertyValues = Lists.newArrayList();
        for (Clause clause : ObjectContracts.clausesFor(propertyNamesIter)) {
            Object propertyValue = clause.getValueOf(obj);
            if (propertyValue == null) continue;
            propertyValues.add(propertyValue);
        }
        return Objects.hashCode((Object[])propertyValues.toArray());
    }

    @Deprecated
    public static boolean equals(Object p, Object q, String propertyNames) {
        if (p == null && q == null) {
            return true;
        }
        if (p == null || q == null) {
            return false;
        }
        if (p.getClass() != q.getClass()) {
            return false;
        }
        Iterable<String> propertyNamesIter = ObjectContracts.csvToIterable(propertyNames);
        return ObjectContracts.equals(p, q, propertyNamesIter);
    }

    @Deprecated
    public static boolean equals(Object p, Object q, String ... propertyNames) {
        if (p == null && q == null) {
            return true;
        }
        if (p == null || q == null) {
            return false;
        }
        if (p.getClass() != q.getClass()) {
            return false;
        }
        List<String> propertyNamesIter = ObjectContracts.varargsToIterable(propertyNames);
        return ObjectContracts.equals(p, q, propertyNamesIter);
    }

    private static boolean equals(Object p, Object q, Iterable<String> propertyNamesIter) {
        Iterable<Clause> clauses = ObjectContracts.clausesFor(propertyNamesIter);
        for (Clause clause : clauses) {
            Object qValue;
            Object pValue = clause.getValueOf(p);
            if (Objects.equal((Object)pValue, (Object)(qValue = clause.getValueOf(q)))) continue;
            return false;
        }
        return true;
    }

    private static Iterable<Clause> clausesFor(Iterable<String> iterable) {
        return Iterables.transform(iterable, (Function)new Function<String, Clause>(){

            public Clause apply(String input) {
                return Clause.parse(input);
            }
        });
    }

    private static Iterable<String> csvToIterable(String propertyNames) {
        return Splitter.on((char)',').split((CharSequence)propertyNames);
    }

    private static List<String> varargsToIterable(String[] iterable) {
        return Arrays.asList(iterable);
    }

    public ObjectContracts with(ToStringEvaluator evaluator) {
        this.evaluators.add(evaluator);
        return this;
    }

    @Deprecated
    public String toStringOf(Object p, String propertyNames) {
        Iterable<String> propertyNamesIter = ObjectContracts.csvToIterable(propertyNames);
        return this.toStringOf(p, propertyNamesIter);
    }

    @Deprecated
    public String toStringOf(Object p, String ... propertyNames) {
        List<String> propertyNamesIter = ObjectContracts.varargsToIterable(propertyNames);
        return this.toStringOf(p, propertyNamesIter);
    }

    private String toStringOf(Object p, Iterable<String> propertyNamesIter) {
        Objects.ToStringHelper stringHelper = Objects.toStringHelper((Object)p);
        for (Clause clause : ObjectContracts.clausesFor(propertyNamesIter)) {
            stringHelper.add(clause.getPropertyName(), (Object)this.asString(clause, p));
        }
        return stringHelper.toString();
    }

    private String asString(Clause clause, Object p) {
        Object value = clause.getValueOf(p);
        if (value == null) {
            return null;
        }
        for (ToStringEvaluator evaluator : this.evaluators) {
            if (!evaluator.canEvaluate(value)) continue;
            return evaluator.evaluate(value);
        }
        return value.toString();
    }

    public static interface ToStringEvaluator {
        public boolean canEvaluate(Object var1);

        public String evaluate(Object var1);
    }
}

