/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.objectstore.jdo.applib.service;

import java.sql.Timestamp;
import java.util.Comparator;
import java.util.UUID;
import javax.inject.Inject;
import org.apache.isis.applib.annotation.Action;
import org.apache.isis.applib.annotation.ActionLayout;
import org.apache.isis.applib.annotation.DomainObject;
import org.apache.isis.applib.annotation.DomainObjectLayout;
import org.apache.isis.applib.annotation.Editing;
import org.apache.isis.applib.annotation.MemberGroupLayout;
import org.apache.isis.applib.annotation.MemberOrder;
import org.apache.isis.applib.annotation.Optionality;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.annotation.Property;
import org.apache.isis.applib.annotation.PropertyLayout;
import org.apache.isis.applib.annotation.SemanticsOf;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.applib.services.bookmark.BookmarkService2;
import org.apache.isis.applib.services.message.MessageService;
import org.apache.isis.applib.services.metamodel.MetaModelService2;
import org.apache.isis.applib.util.ObjectContracts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MemberGroupLayout(columnSpans={6, 0, 6, 12}, left={"Identifiers"}, right={"Target", "Detail"})
@DomainObjectLayout(named="Domain Change")
@DomainObject(editing=Editing.DISABLED)
public abstract class DomainChangeJdoAbstract {
    private static final Logger LOG = LoggerFactory.getLogger(DomainChangeJdoAbstract.class);
    private final ChangeType type;
    private String targetAction;
    @Inject
    protected BookmarkService2 bookmarkService;
    @Inject
    protected MessageService messageService;
    @Inject
    protected MetaModelService2 metaModelService;

    public DomainChangeJdoAbstract(ChangeType changeType) {
        this.type = changeType;
    }

    @Property
    @PropertyLayout(hidden=Where.ALL_EXCEPT_STANDALONE_TABLES)
    @MemberOrder(name="Identifiers", sequence="1")
    public ChangeType getType() {
        return this.type;
    }

    @Property
    @MemberOrder(name="Identifiers", sequence="10")
    public String getUser() {
        return null;
    }

    @Property
    @MemberOrder(name="Identifiers", sequence="20")
    public Timestamp getTimestamp() {
        return null;
    }

    @Property
    @MemberOrder(name="Identifiers", sequence="50")
    public UUID getTransactionId() {
        return null;
    }

    @Property
    @PropertyLayout(named="Class")
    @MemberOrder(name="Target", sequence="10")
    public String getTargetClass() {
        return null;
    }

    @Programmatic
    public Bookmark getTarget() {
        String str = this.getTargetStr();
        return str != null ? new Bookmark(str) : null;
    }

    @Programmatic
    public void setTarget(Bookmark target) {
        String targetStr = target != null ? target.toString() : null;
        this.setTargetStr(targetStr);
    }

    @Property(optionality=Optionality.OPTIONAL)
    @PropertyLayout(named="Member", hidden=Where.ALL_EXCEPT_STANDALONE_TABLES)
    @MemberOrder(name="Target", sequence="20")
    public String getTargetAction() {
        return this.targetAction;
    }

    @Property
    @PropertyLayout(named="Object")
    @MemberOrder(name="Target", sequence="30")
    public String getTargetStr() {
        return null;
    }

    public abstract void setTargetStr(String var1);

    @Action(semantics=SemanticsOf.SAFE)
    @ActionLayout(named="Open")
    @MemberOrder(name="TargetStr", sequence="1")
    public Object openTargetObject() {
        try {
            return this.bookmarkService != null ? this.bookmarkService.lookup(this.getTarget(), BookmarkService2.FieldResetPolicy.DONT_RESET) : null;
        }
        catch (RuntimeException ex) {
            if (ex.getClass().getName().contains("ObjectNotFoundException")) {
                this.messageService.warnUser("Object not found - has it since been deleted?");
                return null;
            }
            throw ex;
        }
    }

    public boolean hideOpenTargetObject() {
        return this.getTarget() == null;
    }

    public String disableOpenTargetObject() {
        Bookmark targetObject = this.getTarget();
        if (targetObject == null) {
            return null;
        }
        MetaModelService2.Sort sortOfObject = this.metaModelService.sortOf(this.getTarget());
        return !sortOfObject.isViewModel() && !sortOfObject.isJdoEntity() ? "Can only open view models or entities" : null;
    }

    @Property(optionality=Optionality.OPTIONAL)
    @PropertyLayout(hidden=Where.ALL_EXCEPT_STANDALONE_TABLES)
    @MemberOrder(name="Target", sequence="21")
    public String getPropertyId() {
        return null;
    }

    @Property(optionality=Optionality.OPTIONAL)
    @PropertyLayout(hidden=Where.ALL_EXCEPT_STANDALONE_TABLES)
    @MemberOrder(name="Detail", sequence="6")
    public String getPreValue() {
        return null;
    }

    @Property(optionality=Optionality.MANDATORY)
    @PropertyLayout(hidden=Where.ALL_EXCEPT_STANDALONE_TABLES)
    @MemberOrder(name="Detail", sequence="7")
    public String getPostValue() {
        return null;
    }

    public static Comparator<DomainChangeJdoAbstract> compareByTimestampDescThenType() {
        return ObjectContracts.compareBy("timestamp desc", "type");
    }

    public static Comparator<DomainChangeJdoAbstract> compareByTargetThenTimestampDescThenType() {
        return ObjectContracts.compareBy("targetStr", "timestamp desc", "type");
    }

    public static Comparator<DomainChangeJdoAbstract> compareByTargetThenUserThenTimestampDescThenType() {
        return ObjectContracts.compareBy("targetStr", "user", "timestamp desc", "type");
    }

    public static Comparator<DomainChangeJdoAbstract> compareByUserThenTimestampDescThenType() {
        return ObjectContracts.compareBy("user", "timestamp desc", "type");
    }

    public static Comparator<DomainChangeJdoAbstract> compareByUserThenTargetThenTimestampDescThenType() {
        return ObjectContracts.compareBy("user", "targetStr", "timestamp desc", "type");
    }

    public static enum ChangeType {
        COMMAND,
        AUDIT_ENTRY,
        PUBLISHED_EVENT,
        PUBLISHED_INTERACTION;


        public String toString() {
            return this.name().replace("_", " ");
        }
    }
}

