/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.schema.utils;

import com.google.common.io.Resources;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.isis.schema.cmd.v1.ActionDto;
import org.apache.isis.schema.cmd.v1.CommandDto;
import org.apache.isis.schema.cmd.v1.ParamsDto;
import org.apache.isis.schema.common.v1.OidsDto;

public final class CommandDtoUtils {
    static JAXBContext jaxbContext;

    public static void init() {
        CommandDtoUtils.getJaxbContext();
    }

    static JAXBContext getJaxbContext() {
        if (jaxbContext == null) {
            try {
                jaxbContext = JAXBContext.newInstance((Class[])new Class[]{CommandDto.class});
            }
            catch (JAXBException e) {
                throw new RuntimeException(e);
            }
        }
        return jaxbContext;
    }

    public static CommandDto fromXml(Reader reader) {
        try {
            Unmarshaller un = CommandDtoUtils.getJaxbContext().createUnmarshaller();
            return (CommandDto)un.unmarshal(reader);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public static CommandDto fromXml(String xml) {
        return CommandDtoUtils.fromXml(new StringReader(xml));
    }

    public static CommandDto fromXml(Class<?> contextClass, String resourceName, Charset charset) throws IOException {
        URL url = Resources.getResource(contextClass, (String)resourceName);
        String s = Resources.toString((URL)url, (Charset)charset);
        return CommandDtoUtils.fromXml(new StringReader(s));
    }

    public static String toXml(CommandDto commandDto) {
        CharArrayWriter caw = new CharArrayWriter();
        CommandDtoUtils.toXml(commandDto, caw);
        return caw.toString();
    }

    public static void toXml(CommandDto commandDto, Writer writer) {
        try {
            Marshaller m = CommandDtoUtils.getJaxbContext().createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            m.marshal((Object)commandDto, writer);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public static OidsDto targetsFor(CommandDto dto) {
        OidsDto targets = dto.getTargets();
        if (targets == null) {
            targets = new OidsDto();
            dto.setTargets(targets);
        }
        return targets;
    }

    public static ParamsDto parametersFor(ActionDto actionDto) {
        ParamsDto parameters = actionDto.getParameters();
        if (parameters == null) {
            parameters = new ParamsDto();
            actionDto.setParameters(parameters);
        }
        return parameters;
    }
}

