/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.schema.utils;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.applib.services.bookmark.BookmarkService;
import org.apache.isis.schema.cmd.v1.ParamDto;
import org.apache.isis.schema.common.v1.EnumDto;
import org.apache.isis.schema.common.v1.OidDto;
import org.apache.isis.schema.common.v1.ValueDto;
import org.apache.isis.schema.common.v1.ValueType;
import org.apache.isis.schema.common.v1.ValueWithTypeDto;
import org.apache.isis.schema.utils.jaxbadapters.JavaSqlTimestampXmlGregorianCalendarAdapter;
import org.apache.isis.schema.utils.jaxbadapters.JodaDateTimeXMLGregorianCalendarAdapter;
import org.apache.isis.schema.utils.jaxbadapters.JodaLocalDateTimeXMLGregorianCalendarAdapter;
import org.apache.isis.schema.utils.jaxbadapters.JodaLocalDateXMLGregorianCalendarAdapter;
import org.apache.isis.schema.utils.jaxbadapters.JodaLocalTimeXMLGregorianCalendarAdapter;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;

public final class CommonDtoUtils {
    public static final Function<ParamDto, String> PARAM_DTO_TO_NAME = new Function<ParamDto, String>(){

        public String apply(ParamDto paramDto) {
            return paramDto.getName();
        }
    };
    public static final Function<ParamDto, ValueType> PARAM_DTO_TO_TYPE = new Function<ParamDto, ValueType>(){

        public ValueType apply(ParamDto paramDto) {
            return paramDto.getType();
        }
    };
    private static final ImmutableMap<Class<?>, ValueType> valueTypeByClass = new ImmutableMap.Builder().put(String.class, (Object)ValueType.STRING).put(Byte.TYPE, (Object)ValueType.BYTE).put(Byte.class, (Object)ValueType.BYTE).put(Short.TYPE, (Object)ValueType.SHORT).put(Short.class, (Object)ValueType.SHORT).put(Integer.TYPE, (Object)ValueType.INT).put(Integer.class, (Object)ValueType.INT).put(Long.TYPE, (Object)ValueType.LONG).put(Long.class, (Object)ValueType.LONG).put(Character.TYPE, (Object)ValueType.CHAR).put(Character.class, (Object)ValueType.CHAR).put(Boolean.TYPE, (Object)ValueType.BOOLEAN).put(Boolean.class, (Object)ValueType.BOOLEAN).put(Float.TYPE, (Object)ValueType.FLOAT).put(Float.class, (Object)ValueType.FLOAT).put(Double.TYPE, (Object)ValueType.DOUBLE).put(Double.class, (Object)ValueType.DOUBLE).put(BigInteger.class, (Object)ValueType.BIG_INTEGER).put(BigDecimal.class, (Object)ValueType.BIG_DECIMAL).put(DateTime.class, (Object)ValueType.JODA_DATE_TIME).put(LocalDateTime.class, (Object)ValueType.JODA_LOCAL_DATE_TIME).put(LocalDate.class, (Object)ValueType.JODA_LOCAL_DATE).put(LocalTime.class, (Object)ValueType.JODA_LOCAL_TIME).put(Timestamp.class, (Object)ValueType.JAVA_SQL_TIMESTAMP).build();

    public static ValueType asValueType(Class<?> type) {
        ValueType valueType = (ValueType)valueTypeByClass.get(type);
        if (valueType != null) {
            return valueType;
        }
        if (type.isEnum()) {
            return ValueType.ENUM;
        }
        return ValueType.REFERENCE;
    }

    public static ValueDto newValueDto(ValueType valueType, Object val, BookmarkService bookmarkService) {
        if (val == null) {
            return null;
        }
        ValueDto valueDto = new ValueDto();
        return CommonDtoUtils.setValueOn(valueDto, valueType, val, bookmarkService);
    }

    public static <T extends ValueWithTypeDto> T setValueOn(T valueWithTypeDto, ValueType valueType, Object val, BookmarkService bookmarkService) {
        CommonDtoUtils.setValueOn(valueWithTypeDto, valueType, val, bookmarkService);
        valueWithTypeDto.setNull(Boolean.valueOf(val == null));
        return valueWithTypeDto;
    }

    public static <T extends ValueDto> T setValueOn(T valueDto, ValueType valueType, Object val, BookmarkService bookmarkService) {
        switch (valueType) {
            case STRING: {
                String argValue = (String)val;
                valueDto.setString(argValue);
                return valueDto;
            }
            case BYTE: {
                Byte argValue = (Byte)val;
                valueDto.setByte(argValue);
                return valueDto;
            }
            case SHORT: {
                Short argValue = (Short)val;
                valueDto.setShort(argValue);
                return valueDto;
            }
            case INT: {
                Integer argValue = (Integer)val;
                valueDto.setInt(argValue);
                return valueDto;
            }
            case LONG: {
                Long argValue = (Long)val;
                valueDto.setLong(argValue);
                return valueDto;
            }
            case CHAR: {
                Character argValue = (Character)val;
                valueDto.setChar("" + argValue);
                return valueDto;
            }
            case BOOLEAN: {
                Boolean argValue = (Boolean)val;
                valueDto.setBoolean(argValue);
                return valueDto;
            }
            case FLOAT: {
                Float argValue = (Float)val;
                valueDto.setFloat(argValue);
                return valueDto;
            }
            case DOUBLE: {
                Double argValue = (Double)val;
                valueDto.setDouble(argValue);
                return valueDto;
            }
            case BIG_INTEGER: {
                BigInteger argValue = (BigInteger)val;
                valueDto.setBigInteger(argValue);
                return valueDto;
            }
            case BIG_DECIMAL: {
                BigDecimal argValue = (BigDecimal)val;
                valueDto.setBigDecimal(argValue);
                return valueDto;
            }
            case JODA_DATE_TIME: {
                DateTime argValue = (DateTime)val;
                valueDto.setDateTime(JodaDateTimeXMLGregorianCalendarAdapter.print((DateTime)argValue));
                return valueDto;
            }
            case JODA_LOCAL_DATE_TIME: {
                LocalDateTime argValue = (LocalDateTime)val;
                valueDto.setLocalDateTime(JodaLocalDateTimeXMLGregorianCalendarAdapter.print((LocalDateTime)argValue));
                return valueDto;
            }
            case JODA_LOCAL_DATE: {
                LocalDate argValue = (LocalDate)val;
                valueDto.setLocalDate(JodaLocalDateXMLGregorianCalendarAdapter.print((LocalDate)argValue));
                return valueDto;
            }
            case JODA_LOCAL_TIME: {
                LocalTime argValue = (LocalTime)val;
                valueDto.setLocalTime(JodaLocalTimeXMLGregorianCalendarAdapter.print((LocalTime)argValue));
                return valueDto;
            }
            case JAVA_SQL_TIMESTAMP: {
                Timestamp argValue = (Timestamp)val;
                valueDto.setTimestamp(JavaSqlTimestampXmlGregorianCalendarAdapter.print((Timestamp)argValue));
                return valueDto;
            }
            case ENUM: {
                Enum argValue = (Enum)val;
                if (argValue == null) {
                    return null;
                }
                EnumDto enumDto = new EnumDto();
                valueDto.setEnum(enumDto);
                enumDto.setEnumType(argValue.getClass().getName());
                enumDto.setEnumName(argValue.name());
                return valueDto;
            }
            case REFERENCE: {
                Bookmark bookmark;
                Bookmark bookmark2 = bookmark = val instanceof Bookmark ? (Bookmark)val : bookmarkService.bookmarkFor(val);
                if (bookmark != null) {
                    OidDto argValue = bookmark != null ? bookmark.toOidDto() : null;
                    valueDto.setReference(argValue);
                }
                return valueDto;
            }
            case VOID: {
                return null;
            }
        }
        throw new IllegalArgumentException(String.format("newValueDto(): do not recognize valueType %s (likely a framework error)", valueType));
    }

    public static <T> T getValue(ValueDto valueDto, ValueType valueType) {
        switch (valueType) {
            case STRING: {
                return (T)valueDto.getString();
            }
            case BYTE: {
                return (T)valueDto.getByte();
            }
            case SHORT: {
                return (T)valueDto.getShort();
            }
            case INT: {
                return (T)valueDto.getInt();
            }
            case LONG: {
                return (T)valueDto.getLong();
            }
            case FLOAT: {
                return (T)valueDto.getFloat();
            }
            case DOUBLE: {
                return (T)valueDto.getDouble();
            }
            case BOOLEAN: {
                return (T)valueDto.isBoolean();
            }
            case CHAR: {
                String aChar = valueDto.getChar();
                if (Strings.isNullOrEmpty((String)aChar)) {
                    return null;
                }
                return (T)Character.valueOf(aChar.charAt(0));
            }
            case BIG_DECIMAL: {
                return (T)valueDto.getBigDecimal();
            }
            case BIG_INTEGER: {
                return (T)valueDto.getBigInteger();
            }
            case JAVA_SQL_TIMESTAMP: {
                return (T)JavaSqlTimestampXmlGregorianCalendarAdapter.parse((XMLGregorianCalendar)valueDto.getDateTime());
            }
            case JODA_DATE_TIME: {
                return (T)JodaDateTimeXMLGregorianCalendarAdapter.parse((XMLGregorianCalendar)valueDto.getDateTime());
            }
            case JODA_LOCAL_DATE: {
                return (T)JodaLocalDateXMLGregorianCalendarAdapter.parse((XMLGregorianCalendar)valueDto.getLocalDate());
            }
            case JODA_LOCAL_DATE_TIME: {
                return (T)JodaLocalDateTimeXMLGregorianCalendarAdapter.parse((XMLGregorianCalendar)valueDto.getLocalDateTime());
            }
            case JODA_LOCAL_TIME: {
                return (T)JodaLocalTimeXMLGregorianCalendarAdapter.parse((XMLGregorianCalendar)valueDto.getLocalTime());
            }
            case ENUM: {
                EnumDto enumDto = valueDto.getEnum();
                String enumType = enumDto.getEnumType();
                Class<T> enumClass = CommonDtoUtils.loadClassElseThrow(enumType);
                return Enum.valueOf(enumClass, enumDto.getEnumName());
            }
            case REFERENCE: {
                return (T)valueDto.getReference();
            }
            case VOID: {
                return null;
            }
        }
        throw new IllegalArgumentException(String.format("getValueDto(...): do not recognize valueType %s (likely a framework error)", valueType));
    }

    private static <T> Class<T> loadClassElseThrow(String enumType) {
        try {
            return CommonDtoUtils.loadClass(enumType);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static Class<?> loadClass(String className) throws ClassNotFoundException {
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        if (ccl == null) {
            return CommonDtoUtils.loadClass(className, null);
        }
        try {
            return CommonDtoUtils.loadClass(className, ccl);
        }
        catch (ClassNotFoundException var3) {
            return CommonDtoUtils.loadClass(className, null);
        }
    }

    private static Class<?> loadClass(String className, ClassLoader classLoader) throws ClassNotFoundException {
        return classLoader == null ? Class.forName(className) : Class.forName(className, true, classLoader);
    }

    public static ValueWithTypeDto newValueWithTypeDto(Class<?> type, Object val, BookmarkService bookmarkService) {
        ValueWithTypeDto valueWithTypeDto = new ValueWithTypeDto();
        ValueType valueType = CommonDtoUtils.asValueType(type);
        valueWithTypeDto.setType(valueType);
        CommonDtoUtils.setValueOn(valueWithTypeDto, valueType, val, bookmarkService);
        return valueWithTypeDto;
    }

    public static <T> T getValue(ValueWithTypeDto valueWithTypeDto) {
        if (valueWithTypeDto.isNull().booleanValue()) {
            return null;
        }
        ValueType type = valueWithTypeDto.getType();
        return CommonDtoUtils.getValue((ValueDto)valueWithTypeDto, type);
    }

    public static ParamDto newParamDto(String parameterName, Class<?> parameterType, Object arg, BookmarkService bookmarkService) {
        ParamDto paramDto = new ParamDto();
        paramDto.setName(parameterName);
        ValueType valueType = CommonDtoUtils.asValueType(parameterType);
        paramDto.setType(valueType);
        CommonDtoUtils.setValueOn(paramDto, valueType, arg, bookmarkService);
        return paramDto;
    }

    public static <T> T getValue(ParamDto paramDto) {
        if (paramDto.isNull().booleanValue()) {
            return null;
        }
        ValueType parameterType = paramDto.getType();
        return CommonDtoUtils.getValue((ValueDto)paramDto, parameterType);
    }
}

