/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.schema.utils.jaxbadapters;

import javax.inject.Inject;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.applib.services.bookmark.BookmarkService;
import org.apache.isis.applib.services.bookmark.BookmarkService2;
import org.apache.isis.schema.common.v1.OidDto;

public class PersistentEntityAdapter
extends XmlAdapter<OidDto, Object> {
    @Inject
    BookmarkService2 bookmarkService;

    public Object unmarshal(OidDto oidDto) throws Exception {
        Bookmark bookmark = Bookmark.from(oidDto);
        return this.bookmarkService.lookup(bookmark, BookmarkService2.FieldResetPolicy.DONT_RESET);
    }

    public OidDto marshal(Object domainObject) throws Exception {
        if (domainObject == null) {
            return null;
        }
        Bookmark bookmark = this.getBookmarkService().bookmarkFor(domainObject);
        return bookmark.toOidDto();
    }

    private static String coalesce(String first, String second) {
        return first != null ? first : second;
    }

    protected BookmarkService getBookmarkService() {
        return this.bookmarkService;
    }
}

