/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.enterprise.context.RequestScoped;
import org.apache.isis.applib.annotation.Programmatic;

@Inherited
@Target(value={ElementType.METHOD})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface Bulk {
    public AppliesTo value() default AppliesTo.BULK_AND_REGULAR;

    @RequestScoped
    public static class InteractionContext {
        @Deprecated
        public static final ThreadLocal<InteractionContext> current = new ThreadLocal();
        private InvokedAs invokedAs;
        private List<Object> domainObjects;
        private int index;

        @Deprecated
        public static void with(Runnable runnable, Object ... domainObjects) {
            throw new RuntimeException("No longer supported - instead inject Bulk.InteractionContext as service");
        }

        @Deprecated
        public static void with(Runnable runnable, InvokedAs invokedAs, Object ... domainObjects) {
            throw new RuntimeException("No longer supported - instead inject Bulk.InteractionContext as service");
        }

        public static InteractionContext regularAction(Object domainObject) {
            return new InteractionContext(InvokedAs.REGULAR, Collections.singletonList(domainObject));
        }

        public static InteractionContext bulkAction(Object ... domainObjects) {
            return InteractionContext.bulkAction(Arrays.asList(domainObjects));
        }

        public static InteractionContext bulkAction(List<Object> domainObjects) {
            return new InteractionContext(InvokedAs.BULK, domainObjects);
        }

        public InteractionContext() {
        }

        @Deprecated
        public InteractionContext(InvokedAs invokedAs, Object ... domainObjects) {
            this(invokedAs, Arrays.asList(domainObjects));
        }

        @Deprecated
        public InteractionContext(InvokedAs invokedAs, List<Object> domainObjects) {
            this.invokedAs = invokedAs;
            this.domainObjects = domainObjects;
        }

        public void setInvokedAs(InvokedAs invokedAs) {
            this.invokedAs = invokedAs;
        }

        public void setDomainObjects(List<Object> domainObjects) {
            this.domainObjects = domainObjects;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        @Programmatic
        public InvokedAs getInvokedAs() {
            return this.invokedAs;
        }

        @Programmatic
        public List<Object> getDomainObjects() {
            return this.domainObjects;
        }

        @Programmatic
        public int getSize() {
            return this.domainObjects.size();
        }

        @Programmatic
        public int getIndex() {
            return this.index;
        }

        @Programmatic
        public boolean isFirst() {
            return this.index == 0;
        }

        @Programmatic
        public boolean isLast() {
            return this.index == this.getSize() - 1;
        }

        public static enum InvokedAs {
            BULK,
            REGULAR;


            public boolean isRegular() {
                return this == REGULAR;
            }

            public boolean isBulk() {
                return this == BULK;
            }
        }
    }

    public static enum AppliesTo {
        BULK_AND_REGULAR,
        BULK_ONLY;

    }
}

