/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.annotation;

import org.apache.isis.applib.marker.AlwaysImmutable;
import org.apache.isis.applib.marker.ImmutableOncePersisted;
import org.apache.isis.applib.marker.ImmutableUntilPersisted;
import org.apache.isis.applib.marker.NeverImmutable;
import org.apache.isis.applib.util.Enums;

public enum When {
    ONCE_PERSISTED,
    UNTIL_PERSISTED,
    ALWAYS,
    NEVER;


    public String getFriendlyName() {
        return Enums.getFriendlyNameOf(this);
    }

    public static When lookupForMarkerInterface(Class<?> cls) {
        if (AlwaysImmutable.class.isAssignableFrom(cls)) {
            return ALWAYS;
        }
        if (ImmutableOncePersisted.class.isAssignableFrom(cls)) {
            return ONCE_PERSISTED;
        }
        if (ImmutableUntilPersisted.class.isAssignableFrom(cls)) {
            return UNTIL_PERSISTED;
        }
        if (NeverImmutable.class.isAssignableFrom(cls)) {
            return NEVER;
        }
        return null;
    }

    public boolean appliesTo(Persistable persistable) {
        boolean isTransient = persistable.isTransient();
        return this == ALWAYS || this == ONCE_PERSISTED && !isTransient || this == UNTIL_PERSISTED && isTransient;
    }

    public static interface Persistable {
        public boolean isTransient();
    }
}

