/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.bookmark;

import com.google.common.base.Splitter;
import java.io.Serializable;
import java.util.Iterator;

public class Bookmark
implements Serializable {
    private static final char SEPARATOR = ':';
    private static final long serialVersionUID = 1L;
    private final String objectType;
    private final String identifier;

    public Bookmark(String toString) {
        this(Splitter.on((char)':').split((CharSequence)toString).iterator());
    }

    private Bookmark(Iterator<String> split) {
        this(split.next(), split.next());
    }

    public Bookmark(String objectType, String identifier) {
        this.objectType = objectType;
        this.identifier = identifier;
    }

    public String getObjectType() {
        return this.objectType;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.identifier == null ? 0 : this.identifier.hashCode());
        result = 31 * result + (this.objectType == null ? 0 : this.objectType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Bookmark other = (Bookmark)obj;
        if (this.identifier == null ? other.identifier != null : !this.identifier.equals(other.identifier)) {
            return false;
        }
        return !(this.objectType == null ? other.objectType != null : !this.objectType.equals(other.objectType));
    }

    public String toString() {
        return this.objectType + ':' + this.identifier;
    }
}

