/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.eventbus;

import com.google.common.eventbus.EventBus;
import org.apache.isis.applib.annotation.Hidden;
import org.apache.isis.applib.annotation.Programmatic;

@Hidden
public abstract class EventBusService {
    public static final EventBusService NOOP = new EventBusService(){

        @Override
        public void register(Object domainObject) {
        }

        @Override
        public void unregister(Object domainObject) {
        }

        @Override
        public void post(Object event) {
        }

        @Override
        protected EventBus getEventBus() {
            return null;
        }
    };

    protected abstract EventBus getEventBus();

    @Programmatic
    public void register(Object domainObject) {
        this.getEventBus().register(domainObject);
    }

    @Programmatic
    public void unregister(Object domainObject) {
        this.getEventBus().unregister(domainObject);
    }

    @Programmatic
    public void post(Object event) {
        if (this.skip(event)) {
            return;
        }
        this.getEventBus().post(event);
    }

    protected boolean skip(Object event) {
        return false;
    }
}

