/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.exceprecog;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.isis.applib.annotation.Hidden;
import org.apache.isis.applib.services.exceprecog.ExceptionRecognizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Hidden
public abstract class ExceptionRecognizerAbstract
implements ExceptionRecognizer {
    public static final Logger LOG = LoggerFactory.getLogger(ExceptionRecognizerAbstract.class);
    private static final String KEY_LOG_RECOGNIZED_EXCEPTIONS = "isis.services.exceprecog.logRecognizedExceptions";
    private final Predicate<Throwable> predicate;
    private final Function<String, String> messageParser;
    private boolean logRecognizedExceptions;

    protected static Function<String, String> constant(final String message) {
        return new Function<String, String>(){

            public String apply(String input) {
                return message;
            }
        };
    }

    protected static Function<String, String> prefix(final String prefix) {
        return new Function<String, String>(){

            public String apply(String input) {
                return prefix + "<br/><br/>" + input;
            }
        };
    }

    public ExceptionRecognizerAbstract(Predicate<Throwable> predicate, Function<String, String> messageParser) {
        this.predicate = predicate;
        this.messageParser = messageParser != null ? messageParser : Functions.identity();
    }

    public ExceptionRecognizerAbstract(Predicate<Throwable> predicate) {
        this(predicate, null);
    }

    @Override
    @PostConstruct
    public void init(Map<String, String> properties) {
        String prop = properties.get(KEY_LOG_RECOGNIZED_EXCEPTIONS);
        this.logRecognizedExceptions = Boolean.parseBoolean(prop);
    }

    @Override
    @PreDestroy
    public void shutdown() {
    }

    @Override
    public String recognize(Throwable ex) {
        List causalChain = Throwables.getCausalChain((Throwable)ex);
        for (Throwable throwable : causalChain) {
            if (!this.predicate.apply((Object)throwable)) continue;
            if (this.logRecognizedExceptions) {
                LOG.info("Recognized exception, stacktrace : ", throwable);
            }
            Throwable rootCause = Throwables.getRootCause((Throwable)throwable);
            String rootCauseMessage = rootCause.getMessage();
            String parsedMessage = (String)this.messageParser.apply((Object)rootCauseMessage);
            return parsedMessage;
        }
        return null;
    }
}

