/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.exceprecog;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.isis.applib.annotation.Hidden;
import org.apache.isis.applib.services.exceprecog.ExceptionRecognizer;

@Hidden
public class ExceptionRecognizerComposite
implements ExceptionRecognizer {
    private final List<ExceptionRecognizer> services = Lists.newArrayList();

    public ExceptionRecognizerComposite(ExceptionRecognizer ... exceptionRecognizers) {
        this(Arrays.asList(exceptionRecognizers));
    }

    public ExceptionRecognizerComposite(List<ExceptionRecognizer> exceptionRecognizers) {
        for (ExceptionRecognizer er : exceptionRecognizers) {
            this.add(er);
        }
    }

    public final void add(ExceptionRecognizer ers) {
        this.services.add(ers);
    }

    @Override
    public final String recognize(Throwable ex) {
        for (ExceptionRecognizer ers : this.services) {
            String message = ers.recognize(ex);
            if (message == null) continue;
            return message;
        }
        return null;
    }

    @Override
    @PostConstruct
    public final void init(Map<String, String> properties) {
        for (ExceptionRecognizer ers : this.services) {
            ers.init(properties);
        }
    }

    @Override
    @PreDestroy
    public final void shutdown() {
        for (ExceptionRecognizer ers : this.services) {
            ers.shutdown();
        }
    }
}

