/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.queryresultscache;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.enterprise.context.RequestScoped;
import org.apache.isis.applib.annotation.Programmatic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
public class QueryResultsCache {
    private static final Logger LOG = LoggerFactory.getLogger(QueryResultsCache.class);
    private final Map<Key, Value<?>> cache = Maps.newHashMap();

    @Programmatic
    public <T> T execute(Callable<T> callable, Class<?> callingClass, String methodName, Object ... keys) {
        Key cacheKey = new Key(callingClass, methodName, keys);
        return this.execute(callable, cacheKey);
    }

    @Programmatic
    public <T> T execute(Callable<T> callable, Key cacheKey) {
        try {
            Value<?> cacheValue = this.cache.get(cacheKey);
            QueryResultsCache.logHitOrMiss(cacheKey, cacheValue);
            if (cacheValue != null) {
                return (T)cacheValue.getResult();
            }
            T result = callable.call();
            this.put(cacheKey, result);
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Programmatic
    public <T> Value<T> get(Class<?> callingClass, String methodName, Object ... keys) {
        return this.get(new Key(callingClass, methodName, keys));
    }

    @Programmatic
    public <T> Value<T> get(Key cacheKey) {
        Value<?> value = this.cache.get(cacheKey);
        QueryResultsCache.logHitOrMiss(cacheKey, value);
        return value;
    }

    @Programmatic
    public <T> void put(Key cacheKey, T result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("PUT: " + cacheKey);
        }
        this.cache.put(cacheKey, new Value<T>(result));
    }

    private static void logHitOrMiss(Key cacheKey, Value<?> cacheValue) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        String hitOrMiss = cacheValue != null ? "HIT" : "MISS";
        LOG.debug(hitOrMiss + ": " + cacheKey.toString());
    }

    public static class Value<T> {
        private T result;

        public Value(T result) {
            this.result = result;
        }

        public T getResult() {
            return this.result;
        }
    }

    public static class Key {
        private final Class<?> callingClass;
        private final String methodName;
        private final Object[] keys;

        public Key(Class<?> callingClass, String methodName, Object ... keys) {
            this.callingClass = callingClass;
            this.methodName = methodName;
            this.keys = keys;
        }

        public Class<?> getCallingClass() {
            return this.callingClass;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public Object[] getKeys() {
            return this.keys;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            if (this.callingClass == null ? other.callingClass != null : !this.callingClass.equals(other.callingClass)) {
                return false;
            }
            if (!Arrays.equals(this.keys, other.keys)) {
                return false;
            }
            return !(this.methodName == null ? other.methodName != null : !this.methodName.equals(other.methodName));
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.callingClass == null ? 0 : this.callingClass.hashCode());
            result = 31 * result + Arrays.hashCode(this.keys);
            result = 31 * result + (this.methodName == null ? 0 : this.methodName.hashCode());
            return result;
        }

        public String toString() {
            return this.callingClass.getName() + "#" + this.methodName + Arrays.toString(this.keys);
        }
    }
}

