/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.settings;

import org.apache.isis.applib.annotation.Hidden;
import org.apache.isis.applib.annotation.Immutable;
import org.apache.isis.applib.annotation.MemberOrder;
import org.apache.isis.applib.annotation.Named;
import org.apache.isis.applib.annotation.Optional;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.annotation.Title;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.applib.services.settings.Setting;
import org.apache.isis.applib.services.settings.SettingType;
import org.joda.time.LocalDate;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

@Immutable
public abstract class SettingAbstract
implements Setting {
    public static final DateTimeFormatter DATE_FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd");

    @Override
    @Title(sequence="10")
    @MemberOrder(sequence="10")
    public abstract String getKey();

    @Override
    @Optional
    @MemberOrder(sequence="80")
    public abstract String getDescription();

    @Override
    @MemberOrder(sequence="90")
    public abstract SettingType getType();

    @Override
    @Title(prepend=" = ", sequence="30")
    @MemberOrder(sequence="30")
    @Hidden(where=Where.OBJECT_FORMS)
    public abstract String getValueRaw();

    @Override
    @Programmatic
    public String valueAsString() {
        this.ensure(SettingType.STRING);
        return this.getValueRaw();
    }

    @Override
    @Programmatic
    public LocalDate valueAsLocalDate() {
        this.ensure(SettingType.LOCAL_DATE);
        return this.parseValueAsLocalDate();
    }

    protected LocalDate parseValueAsLocalDate() {
        return LocalDate.parse((String)this.getValueRaw(), (DateTimeFormatter)DATE_FORMATTER);
    }

    @Override
    @Programmatic
    public Integer valueAsInt() {
        this.ensure(SettingType.INT);
        return this.parseValueAsInt();
    }

    protected int parseValueAsInt() {
        return Integer.parseInt(this.getValueRaw());
    }

    @Override
    @Programmatic
    public Long valueAsLong() {
        this.ensure(SettingType.LONG);
        return this.parseValueAsLong();
    }

    protected long parseValueAsLong() {
        return Long.parseLong(this.getValueRaw());
    }

    @Override
    @Programmatic
    public Boolean valueAsBoolean() {
        this.ensure(SettingType.BOOLEAN);
        return this.parseValueAsBoolean();
    }

    protected boolean parseValueAsBoolean() {
        return Boolean.parseBoolean(this.getValueRaw());
    }

    @MemberOrder(sequence="30")
    @Hidden(where=Where.ALL_TABLES)
    @Named(value="Value")
    public String getValueAsString() {
        return this.getValueRaw();
    }

    public boolean hideValueAsString() {
        return this.typeIsNot(SettingType.STRING);
    }

    @MemberOrder(sequence="30")
    @Hidden(where=Where.ALL_TABLES)
    @Named(value="Value")
    public LocalDate getValueAsLocalDate() {
        return this.parseValueAsLocalDate();
    }

    public boolean hideValueAsLocalDate() {
        return this.typeIsNot(SettingType.LOCAL_DATE);
    }

    @MemberOrder(sequence="30")
    @Hidden(where=Where.ALL_TABLES)
    @Named(value="Value")
    public Integer getValueAsInt() {
        return this.parseValueAsInt();
    }

    public boolean hideValueAsInt() {
        return this.typeIsNot(SettingType.INT);
    }

    @MemberOrder(sequence="30")
    @Hidden(where=Where.ALL_TABLES)
    @Named(value="Value")
    public Long getValueAsLong() {
        return this.parseValueAsLong();
    }

    public boolean hideValueAsLong() {
        return this.typeIsNot(SettingType.LONG);
    }

    @MemberOrder(sequence="30")
    @Hidden(where=Where.ALL_TABLES)
    @Named(value="Value")
    public Boolean getValueAsBoolean() {
        return this.parseValueAsBoolean();
    }

    public boolean hideValueAsBoolean() {
        return this.typeIsNot(SettingType.BOOLEAN);
    }

    private void ensure(SettingType settingType) {
        if (this.typeIsNot(settingType)) {
            throw new IllegalStateException("Setting '" + this.getKey() + "' is of type " + (Object)((Object)this.getType()) + ", not of type " + (Object)((Object)settingType));
        }
    }

    protected boolean typeIsNot(SettingType settingType) {
        return this.getType() != settingType;
    }
}

