/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.util;

import com.google.common.base.Strings;
import com.google.common.collect.Ordering;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class Clause {
    private static Pattern pattern = Pattern.compile("\\W*(\\w+)\\W*(asc|asc nullsFirst|asc nullsLast|desc|desc nullsFirst|desc nullsLast)?\\W*");
    private String propertyName;
    private Direction direction;

    static Clause parse(String input) {
        Matcher matcher = pattern.matcher(input);
        if (!matcher.matches()) {
            return null;
        }
        return new Clause(matcher.group(1), Direction.valueOfElseAsc(matcher.group(2)));
    }

    Clause(String propertyName, Direction direction) {
        this.propertyName = propertyName;
        this.direction = direction;
    }

    String getPropertyName() {
        return this.propertyName;
    }

    Direction getDirection() {
        return this.direction;
    }

    public Object getValueOf(Object obj) {
        if (obj == null) {
            return null;
        }
        String methodNameSuffix = Clause.upperFirst(this.propertyName);
        String getMethodName = "get" + methodNameSuffix;
        try {
            Method getterMethod = obj.getClass().getMethod(getMethodName, new Class[0]);
            return getterMethod.invoke(obj, new Object[0]);
        }
        catch (Exception e) {
            String isMethodName = "is" + methodNameSuffix;
            try {
                Method getterMethod = obj.getClass().getMethod(isMethodName, new Class[0]);
                return getterMethod.invoke(obj, new Object[0]);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("No such method ' " + getMethodName + "' or '" + isMethodName + "'", e);
            }
        }
    }

    private static String upperFirst(String str) {
        if (Strings.isNullOrEmpty((String)str)) {
            return str;
        }
        if (str.length() == 1) {
            return str.toUpperCase();
        }
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    static enum Direction {
        ASC{

            @Override
            public Comparator<Comparable<?>> getOrdering() {
                return Ordering.natural().nullsFirst();
            }
        }
        ,
        ASC_NULLS_LAST{

            @Override
            public Comparator<Comparable<?>> getOrdering() {
                return Ordering.natural().nullsLast();
            }
        }
        ,
        DESC{

            @Override
            public Comparator<Comparable<?>> getOrdering() {
                return Ordering.natural().nullsLast().reverse();
            }
        }
        ,
        DESC_NULLS_LAST{

            @Override
            public Comparator<Comparable<?>> getOrdering() {
                return Ordering.natural().nullsFirst().reverse();
            }
        };


        public abstract Comparator<Comparable<?>> getOrdering();

        public static Direction valueOfElseAsc(String str) {
            if ("asc".equals(str)) {
                return ASC;
            }
            if ("asc nullsFirst".equals(str)) {
                return ASC;
            }
            if ("asc nullsLast".equals(str)) {
                return ASC_NULLS_LAST;
            }
            if ("desc".equals(str)) {
                return DESC;
            }
            if ("desc nullsFirst".equals(str)) {
                return DESC;
            }
            if ("desc nullsLast".equals(str)) {
                return DESC_NULLS_LAST;
            }
            return ASC;
        }
    }
}

