/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.util;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.isis.applib.util.Clause;

public class ObjectContracts {
    private final List<ToStringEvaluator> evaluators = Lists.newArrayList();

    public static <T> int compare(T p, T q, String propertyNames) {
        ComparisonChain chain = ComparisonChain.start();
        for (Clause clause : ObjectContracts.iterable(propertyNames)) {
            Comparable propertyValue = (Comparable)clause.getValueOf(p);
            Comparable propertyValue2 = (Comparable)clause.getValueOf(q);
            chain = chain.compare((Object)propertyValue, (Object)propertyValue2, clause.getDirection().getOrdering());
        }
        return chain.result();
    }

    public static <T> Comparator<T> compareBy(final String propertyNames) {
        return new Comparator<T>(){

            @Override
            public int compare(T p, T q) {
                return ObjectContracts.compare(p, q, propertyNames);
            }
        };
    }

    public static String toString(Object p, String propertyNames) {
        return new ObjectContracts().toStringOf(p, propertyNames);
    }

    public static int hashCode(Object obj, String propertyNames) {
        ArrayList propertyValues = Lists.newArrayList();
        for (Clause clause : ObjectContracts.iterable(propertyNames)) {
            Object propertyValue = clause.getValueOf(obj);
            if (propertyValue == null) continue;
            propertyValues.add(propertyValue);
        }
        return Objects.hashCode((Object[])propertyValues.toArray());
    }

    public static boolean equals(Object p, Object q, String propertyNames) {
        for (Clause clause : ObjectContracts.iterable(propertyNames)) {
            Object qValue;
            Object pValue = clause.getValueOf(p);
            if (Objects.equal((Object)pValue, (Object)(qValue = clause.getValueOf(q)))) continue;
            return false;
        }
        return true;
    }

    private static Iterable<Clause> iterable(String propertyNames) {
        return Iterables.transform((Iterable)Splitter.on((char)',').split((CharSequence)propertyNames), (Function)new Function<String, Clause>(){

            public Clause apply(String input) {
                return Clause.parse(input);
            }
        });
    }

    public ObjectContracts with(ToStringEvaluator evaluator) {
        this.evaluators.add(evaluator);
        return this;
    }

    public String toStringOf(Object p, String propertyNames) {
        Objects.ToStringHelper stringHelper = Objects.toStringHelper((Object)p);
        for (Clause clause : ObjectContracts.iterable(propertyNames)) {
            stringHelper.add(clause.getPropertyName(), (Object)this.asString(clause, p));
        }
        return stringHelper.toString();
    }

    private String asString(Clause clause, Object p) {
        Object value = clause.getValueOf(p);
        if (value == null) {
            return null;
        }
        for (ToStringEvaluator evaluator : this.evaluators) {
            if (!evaluator.canEvaluate(value)) continue;
            return evaluator.evaluate(value);
        }
        return value.toString();
    }

    public static interface ToStringEvaluator {
        public boolean canEvaluate(Object var1);

        public String evaluate(Object var1);
    }
}

