/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.value;

import org.apache.isis.applib.annotation.Value;
import org.apache.isis.applib.value.Magnitude;

@Value(semanticsProviderName="org.apache.isis.core.progmodel.facets.value.percentage.PercentageValueSemanticsProvider")
public class Percentage
extends Magnitude<Percentage> {
    private static final long serialVersionUID = 1L;
    private final float value;

    public Percentage(float value) {
        this.value = value;
    }

    public Percentage add(float value) {
        return new Percentage(this.floatValue() + value);
    }

    public Percentage add(Percentage value) {
        return this.add(value.floatValue());
    }

    public double doubleValue() {
        return this.value;
    }

    public float floatValue() {
        return this.value;
    }

    public int intValue() {
        return (int)this.value;
    }

    @Override
    public boolean isEqualTo(Percentage magnitude) {
        return magnitude.value == this.value;
    }

    @Override
    public boolean isLessThan(Percentage magnitude) {
        return this.value < magnitude.value;
    }

    public long longValue() {
        return (long)this.value;
    }

    public Percentage multiply(float value) {
        return new Percentage(this.floatValue() * value);
    }

    public short shortValue() {
        return (short)this.value;
    }

    public Percentage subtract(float value) {
        return this.add(-value);
    }

    public Percentage subtract(Percentage value) {
        return this.add(-value.floatValue());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        return other.getClass() == this.getClass() && this.equals((Percentage)other);
    }

    public boolean equals(Percentage other) {
        return this.value == other.value;
    }

    public int hashCode() {
        return (int)(this.floatValue() * 100.0f);
    }

    public String toString() {
        return "" + this.value;
    }
}

