/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.value;

import java.util.Date;
import org.apache.isis.applib.Defaults;
import org.apache.isis.applib.annotation.Value;
import org.apache.isis.applib.clock.Clock;
import org.apache.isis.applib.value.Magnitude;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.DateTimeFormat;

@Value(semanticsProviderName="org.apache.isis.core.progmodel.facets.value.time.TimeValueSemanticsProvider")
public class Time
extends Magnitude<Time> {
    private static final long serialVersionUID = 1L;
    public static final int MINUTE = 60;
    public static final int HOUR = 3600;
    public static final int DAY = 86400;
    private final DateTime time;

    public Time() {
        DateTime dateTime = Clock.getTimeAsDateTime();
        this.time = dateTime.withDate(1970, 1, 1);
    }

    private DateTime newDateTime(int hourOfDay, int minuteOfHour, int secondsOfMinute) {
        return new DateTime(1970, 1, 1, hourOfDay, minuteOfHour, secondsOfMinute, 0, Defaults.getTimeZone());
    }

    public Time(int hour, int minute) {
        this(hour, minute, 0);
    }

    public Time(int hour, int minute, int second) {
        this.time = this.time(hour, minute, second);
    }

    private DateTime time(int hour, int minute, int seconds) {
        this.checkTime(hour, minute, seconds);
        return this.newDateTime(hour, minute, seconds);
    }

    public Time(java.sql.Date date) {
        this.time = new DateTime(date.getTime(), Defaults.getTimeZone());
    }

    public Time(Date date, DateTimeZone dateTimeZone) {
        DateTime DateTime2 = new DateTime(date.getTime(), dateTimeZone);
        this.time = DateTime2.secondOfMinute().setCopy(0);
    }

    public Time(DateTime dateTime) {
        this.time = this.newDateTime(dateTime.getHourOfDay(), dateTime.getMinuteOfHour(), dateTime.getSecondOfMinute());
    }

    public Time(long millisSinceEpoch) {
        this.time = new DateTime(millisSinceEpoch, Defaults.getTimeZone());
    }

    public Time add(int hours, int minutes) {
        Period period = new Period(hours, minutes, 0, 0);
        return new Time(this.time.plus((ReadablePeriod)period));
    }

    private void checkTime(int hour, int minute, int second) {
        if (hour < 0 || hour > 23) {
            throw new IllegalArgumentException("Hour must be in the range 0 - 23 inclusive");
        }
        if (minute < 0 || minute > 59) {
            throw new IllegalArgumentException("Minute must be in the range 0 - 59 inclusive");
        }
        if (second < 0 || second > 59) {
            throw new IllegalArgumentException("Second must be in the range 0 - 59 inclusive");
        }
    }

    public int getHour() {
        return this.time.getHourOfDay();
    }

    public int getMinute() {
        return this.time.getMinuteOfHour();
    }

    public int getSecond() {
        return this.time.getSecondOfMinute();
    }

    @Override
    public boolean isEqualTo(Time time) {
        return time == null ? false : this.equals(time);
    }

    @Override
    public boolean isLessThan(Time time) {
        return time != null && this.time.isBefore((ReadableInstant)time.time);
    }

    @Deprecated
    public long longValue() {
        return this.time.getMillisOfDay() / 1000;
    }

    public long secondsSinceMidnight() {
        return this.milliSecondsSinceMidnight() / 1000L;
    }

    public long milliSecondsSinceMidnight() {
        return this.time.getMillisOfDay();
    }

    public String titleString() {
        return this.time == null ? "" : DateTimeFormat.shortTime().print((ReadableInstant)this.time);
    }

    public boolean sameHourAs(Time time) {
        return this.getHour() == time.getHour();
    }

    public boolean sameMinuteAs(Time time) {
        return this.getMinute() == time.getMinute();
    }

    public Time onTheHour() {
        return new Time(this.getHour(), 0);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.time == null ? 0 : this.time.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Time other = (Time)obj;
        return !(this.time == null ? other.time != null : !this.time.equals((Object)other.time));
    }

    public Date asJavaDate() {
        return this.time.toDate();
    }

    public java.sql.Time asJavaTime() {
        java.sql.Time time1 = java.sql.Time.valueOf(this.toString());
        return time1;
    }

    public String toString() {
        return String.format("%02d:%02d:%02d", this.getHour(), this.getMinute(), this.getSecond());
    }
}

