/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.bytecode.javassist;

import java.lang.reflect.Method;
import javassist.util.proxy.MethodFilter;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyFactory;
import javassist.util.proxy.ProxyObject;
import org.apache.isis.core.bytecode.javassist.JavassistEnhanced;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.commons.lang.ArrayUtils;
import org.apache.isis.core.metamodel.facets.ImperativeFacetUtils;
import org.apache.isis.core.metamodel.spec.SpecificationLoaderSpi;
import org.apache.isis.core.metamodel.spec.feature.ObjectMember;
import org.apache.isis.core.metamodel.specloader.specimpl.dflt.ObjectSpecificationDefault;
import org.apache.isis.core.runtime.bytecode.ObjectResolveAndObjectChangedEnhancerAbstract;
import org.apache.isis.core.runtime.persistence.objectfactory.ObjectChanger;
import org.apache.isis.core.runtime.persistence.objectfactory.ObjectResolver;

public class ObjectResolveAndObjectChangedEnhancer
extends ObjectResolveAndObjectChangedEnhancerAbstract {
    private MethodHandler methodHandler;

    public ObjectResolveAndObjectChangedEnhancer(ObjectResolver objectResolver, ObjectChanger objectChanger, SpecificationLoaderSpi specificationLoader) {
        super(objectResolver, objectChanger, specificationLoader);
        this.createCallback();
    }

    protected void createCallback() {
        this.methodHandler = new MethodHandler(){

            public Object invoke(Object proxied, Method proxyMethod, Method proxiedMethod, Object[] args) throws Throwable {
                ObjectSpecificationDefault targetObjSpec;
                ObjectMember member;
                boolean ignore = proxyMethod.getDeclaringClass().equals(Object.class);
                ImperativeFacetUtils.ImperativeFacetFlags flags = null;
                if (!ignore && (flags = ImperativeFacetUtils.getImperativeFacetFlags((ObjectMember)(member = (targetObjSpec = ObjectResolveAndObjectChangedEnhancer.this.getJavaSpecificationOfOwningClass(proxiedMethod)).getMember(proxiedMethod)), (Method)proxiedMethod)).impliesResolve()) {
                    ObjectResolveAndObjectChangedEnhancer.this.objectResolver.resolve(proxied, member.getName());
                }
                Object proxiedReturn = proxiedMethod.invoke(proxied, args);
                if (!ignore && flags.impliesObjectChanged()) {
                    ObjectResolveAndObjectChangedEnhancer.this.objectChanger.objectChanged(proxied);
                }
                return proxiedReturn;
            }
        };
    }

    public <T> T newInstance(Class<T> cls) {
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.setSuperclass(cls);
        proxyFactory.setInterfaces((Class[])ArrayUtils.combine((Object[][])new Class[][]{cls.getInterfaces(), {JavassistEnhanced.class}}));
        proxyFactory.setFilter(new MethodFilter(){

            public boolean isHandled(Method m) {
                return !m.getName().equals("finalize");
            }
        });
        Class proxySubclass = proxyFactory.createClass();
        try {
            Object newInstance = proxySubclass.newInstance();
            ProxyObject proxyObject = (ProxyObject)newInstance;
            proxyObject.setHandler(this.methodHandler);
            return newInstance;
        }
        catch (InstantiationException e) {
            throw new IsisException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new IsisException((Throwable)e);
        }
    }
}

