/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.integtestsupport;

import java.util.List;
import org.apache.isis.applib.services.exceprecog.ExceptionRecognizer;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.junit.rules.MethodRule;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

public class ExceptionRecognizerTranslate
implements MethodRule {
    public static ExceptionRecognizerTranslate create() {
        return new ExceptionRecognizerTranslate();
    }

    private ExceptionRecognizerTranslate() {
    }

    public Statement apply(Statement statement, FrameworkMethod frameworkMethod, Object o) {
        return new TranslationStatement(statement);
    }

    private void recognize(Throwable ex) {
        List exceptionRecognizers = this.getIsisSessionFactory().getServicesInjector().lookupServices(ExceptionRecognizer.class);
        for (ExceptionRecognizer exceptionRecognizer : exceptionRecognizers) {
            String unused = exceptionRecognizer.recognize(ex);
        }
    }

    IsisSessionFactory getIsisSessionFactory() {
        return IsisContext.getSessionFactory();
    }

    private class TranslationStatement
    extends Statement {
        private final Statement next;

        public TranslationStatement(Statement base) {
            this.next = base;
        }

        public void evaluate() throws Throwable {
            try {
                this.next.evaluate();
            }
            catch (Throwable ex) {
                ExceptionRecognizerTranslate.this.recognize(ex);
                throw ex;
            }
        }
    }
}

